/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.cash.zhangfangyun.local.service.internal;

import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.external.cash.zhangfangyun.local.entity.ContractTemplate;
import com.biz.crm.cps.external.cash.zhangfangyun.local.repository.ContractTemplateRepository;
import com.biz.crm.cps.external.cash.zhangfangyun.local.service.ContractTemplateService;
import com.biz.crm.cps.external.cash.zhangfangyun.sdk.service.FadadaService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.util.Date;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ContractTemplateServiceImpl
implements ContractTemplateService {
    @Autowired
    private ContractTemplateRepository contractTemplateRepository;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private FadadaService fadadaService;

    @Override
    @Transactional
    public ContractTemplate create(ContractTemplate template) {
        this.createValidation(template);
        String templateId = String.valueOf(System.currentTimeMillis());
        template.setTemplateId(templateId);
        this.buildContractTemplate(template);
        this.fadadaService.uploadTemplate(templateId, template.getDocUrl());
        this.contractTemplateRepository.save((Object)template);
        return template;
    }

    @Override
    public ContractTemplate findTopOne() {
        return this.contractTemplateRepository.findTopOne();
    }

    private void createValidation(ContractTemplate template) {
        Validate.notNull((Object)((Object)template), (String)"\u521b\u5efa\u5408\u540c\u6a21\u677f\u65f6\uff0c\u5408\u540c\u6a21\u677f\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        template.setId(null);
        Validate.notBlank((CharSequence)template.getDocUrl(), (String)"\u521b\u5efa\u5408\u540c\u6a21\u677f\u65f6\uff0c\u6a21\u677f\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void buildContractTemplate(ContractTemplate template) {
        template.setTenantCode(TenantUtils.getTenantCode());
        template.setCreateTime(new Date());
        template.setCreateAccount(this.loginUserService.getLoginAccountName());
        template.setModifyTime(new Date());
        template.setModifyAccount(this.loginUserService.getLoginAccountName());
        template.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        template.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    }
}

