/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.cash.zhangfangyun.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.external.cash.zhangfangyun.local.config.FadadaConfig;
import com.biz.crm.cps.external.cash.zhangfangyun.local.entity.FadadaAccount;
import com.biz.crm.cps.external.cash.zhangfangyun.local.repository.FadadaAccountRepository;
import com.biz.crm.cps.external.cash.zhangfangyun.local.service.FadadaAccountService;
import com.biz.crm.cps.external.cash.zhangfangyun.sdk.common.enums.FadadaAccountTypeEnum;
import com.biz.crm.cps.external.cash.zhangfangyun.sdk.common.enums.FadadaCompanyVerifyStatusEnum;
import com.biz.crm.cps.external.cash.zhangfangyun.sdk.common.enums.FadadaPersonVerifyStatusEnum;
import com.biz.crm.cps.external.cash.zhangfangyun.sdk.dto.CompanyVerifyUrlDto;
import com.biz.crm.cps.external.cash.zhangfangyun.sdk.dto.FadadaAuthDto;
import com.biz.crm.cps.external.cash.zhangfangyun.sdk.model.FadadaResult;
import com.biz.crm.cps.external.cash.zhangfangyun.sdk.service.FadadaService;
import com.biz.crm.cps.external.cash.zhangfangyun.sdk.vo.CertInfoVo;
import com.biz.crm.cps.external.cash.zhangfangyun.sdk.vo.VerifyUrlVo;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.util.Date;
import java.util.List;
import jodd.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class FadadaAccountServiceImpl
implements FadadaAccountService {
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired
    private FadadaAccountRepository fadadaAccountRepository;
    @Autowired
    private FadadaService fadadaService;
    @Autowired
    private FadadaConfig fadadaConfig;

    @Override
    public FadadaAccount findByUserAccountAndUserType(String userAccount, String userType) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{userAccount, userType})) {
            return null;
        }
        return this.fadadaAccountRepository.findByUserAccountAndUserType(userAccount, userType);
    }

    @Override
    @Transactional
    public FadadaAccount create(FadadaAccount fadadaAccount) {
        Validate.notNull((Object)((Object)fadadaAccount), (String)"\u6cd5\u5927\u5927\u8d26\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)fadadaAccount.getUserAccount(), (String)"\u7528\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)fadadaAccount.getUserType(), (String)"\u7528\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)fadadaAccount.getAccountType(), (String)"\u8d26\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        FadadaAccount old = this.findByUserAccountAndUserType(fadadaAccount.getUserAccount(), fadadaAccount.getUserType());
        if (old == null) {
            FadadaResult registerFadadaAccount = this.fadadaService.registerAccount(fadadaAccount.getUserAccount(), fadadaAccount.getAccountType());
            Validate.notNull((Object)registerFadadaAccount.getData(), (String)"\u6ce8\u518c\u8d26\u53f7\u8fd4\u56de\u7684\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            fadadaAccount.setCustomerId(registerFadadaAccount.getData());
            FadadaResult fadadaResult = null;
            if (fadadaAccount.getAccountType().equals(FadadaAccountTypeEnum.PERSON.getDictCode())) {
                fadadaResult = this.fadadaService.findPersonVerifyUrl(fadadaAccount.getCustomerId(), "5", "1");
            } else if (fadadaAccount.getAccountType().equals(FadadaAccountTypeEnum.COMPANY.getDictCode())) {
                CompanyVerifyUrlDto companyVerifyUrlDto = new CompanyVerifyUrlDto();
                companyVerifyUrlDto.setCustomerId(fadadaAccount.getCustomerId());
                companyVerifyUrlDto.setMVerifiedWay("5");
                companyVerifyUrlDto.setPageModify("1");
                companyVerifyUrlDto.setVerifiedWay("1");
                fadadaResult = this.fadadaService.findCompanyVerifyUrl(companyVerifyUrlDto);
            }
            String data = fadadaResult.getData();
            Validate.notNull((Object)data, (String)"\u83b7\u53d6\u5b9e\u540d\u8ba4\u8bc1\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            VerifyUrlVo verifyUrlVo = (VerifyUrlVo)JSONObject.parseObject((String)data, VerifyUrlVo.class);
            String url = Base64.decodeToString((String)verifyUrlVo.getUrl());
            if (this.fadadaConfig != null && StringUtils.isNotBlank((CharSequence)this.fadadaConfig.getAppletRealnameverifyHost()) && StringUtils.isNotBlank((CharSequence)this.fadadaConfig.getRealnameverifyHost())) {
                url = url.replace(this.fadadaConfig.getRealnameverifyHost(), this.fadadaConfig.getAppletRealnameverifyHost());
            }
            fadadaAccount.setVerifyUrl(url);
            fadadaAccount.setTransactionNo(verifyUrlVo.getTransactionNo());
            this.createForm(fadadaAccount);
            this.fadadaAccountRepository.save((Object)fadadaAccount);
            return fadadaAccount;
        }
        return old;
    }

    @Override
    @Transactional
    public FadadaAccount updateStatus(FadadaAuthDto dto) {
        this.updateStatusValidation(dto);
        FadadaAccount byCustomerId = this.fadadaAccountRepository.findByCustomerId(dto.getCustomerId());
        Validate.isTrue((byCustomerId != null ? 1 : 0) != 0, (String)"\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u6570\u636e", (Object[])new Object[0]);
        BeanUtils.copyProperties((Object)dto, (Object)((Object)byCustomerId));
        byCustomerId.setModifyTime(new Date());
        byCustomerId.setModifyAccount(this.loginUserService.getLoginAccountName());
        if (byCustomerId.getAccountType().equals(FadadaAccountTypeEnum.PERSON.getDictCode())) {
            FadadaResult fadadaResult = this.fadadaService.findPersonCertInfoByTransactionNo(byCustomerId.getTransactionNo());
            JSONObject object = JSONObject.parseObject((String)fadadaResult.getData());
            CertInfoVo certInfoVo = (CertInfoVo)JSONObject.parseObject((String)object.getString("person"), CertInfoVo.class);
            BeanUtils.copyProperties((Object)certInfoVo, (Object)((Object)byCustomerId));
            if (StringUtils.isNotBlank((CharSequence)certInfoVo.getHeadPhotoPath())) {
                String headPhotoPathUrl = this.fadadaService.findFileByUuid(certInfoVo.getHeadPhotoPath());
                byCustomerId.setHeadPhotoPathUrl(headPhotoPathUrl);
            }
            if (StringUtils.isNotBlank((CharSequence)certInfoVo.getBackgroundIdCardPath())) {
                String backgroundIdCardPathUrl = this.fadadaService.findFileByUuid(certInfoVo.getBackgroundIdCardPath());
                byCustomerId.setBackgroundIdCardPathUrl(backgroundIdCardPathUrl);
            }
        }
        if (FadadaPersonVerifyStatusEnum.PASSED.getDictCode().equals(dto.getStatus()) || FadadaCompanyVerifyStatusEnum.PASSED.getDictCode().equals(dto.getStatus())) {
            this.fadadaService.applyCert(byCustomerId.getCustomerId(), byCustomerId.getTransactionNo());
        }
        this.fadadaAccountRepository.updateById((Object)byCustomerId);
        return byCustomerId;
    }

    @Override
    public FadadaAccount findByCustomerId(String customerId) {
        if (StringUtils.isBlank((CharSequence)customerId)) {
            return null;
        }
        return this.fadadaAccountRepository.findByCustomerId(customerId);
    }

    @Override
    public FadadaAccount findByAccountType(String accountType) {
        if (StringUtils.isBlank((CharSequence)accountType)) {
            return null;
        }
        List<FadadaAccount> list = this.fadadaAccountRepository.findByAccountType(accountType);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    private void createForm(FadadaAccount fadadaAccount) {
        fadadaAccount.setId(null);
        fadadaAccount.setTenantCode(TenantUtils.getTenantCode());
        fadadaAccount.setCreateTime(new Date());
        fadadaAccount.setCreateAccount(this.loginUserService.getLoginUser().getConsumerCode());
        fadadaAccount.setModifyTime(new Date());
        fadadaAccount.setModifyAccount(this.loginUserService.getLoginUser().getConsumerCode());
        fadadaAccount.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        fadadaAccount.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    }

    private void updateStatusValidation(FadadaAuthDto dto) {
        Validate.notNull((Object)dto, (String)"\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u4fee\u6539\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getSerialNo(), (String)"\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u8ba4\u8bc1\u5e8f\u5217\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getCustomerId(), (String)"\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5ba2\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getStatus(), (String)"\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u6cd5\u5927\u5927\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

