/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.cash.zhangfangyun.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.external.cash.zhangfangyun.local.config.FadadaConfig;
import com.biz.crm.cps.external.cash.zhangfangyun.sdk.dto.CompanyVerifyUrlDto;
import com.biz.crm.cps.external.cash.zhangfangyun.sdk.model.FadadaResult;
import com.biz.crm.cps.external.cash.zhangfangyun.sdk.service.FadadaService;
import com.fadada.sdk.base.client.FddBaseClient;
import com.fadada.sdk.base.model.req.BeforeAuthSignParams;
import com.fadada.sdk.base.model.req.ContractFillingParams;
import com.fadada.sdk.base.model.req.DownloadPdfParams;
import com.fadada.sdk.base.model.req.ExtSignAutoParams;
import com.fadada.sdk.base.model.req.ExtSignParams;
import com.fadada.sdk.base.model.req.GenerateContractParams;
import com.fadada.sdk.base.model.req.RegisterAccountParams;
import com.fadada.sdk.base.model.req.UploadTemplateParams;
import com.fadada.sdk.base.model.req.ViewPdfURLParams;
import com.fadada.sdk.verify.client.FddVerifyClient;
import com.fadada.sdk.verify.model.req.ApplyCertParams;
import com.fadada.sdk.verify.model.req.CompanyVerifyUrlParams;
import com.fadada.sdk.verify.model.req.FileForUUIDParams;
import com.fadada.sdk.verify.model.req.FindPersonCertParams;
import com.fadada.sdk.verify.model.req.PersonVerifyUrlParams;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FadadaServiceImpl
implements FadadaService {
    private static final Logger log = LoggerFactory.getLogger(FadadaServiceImpl.class);
    @Autowired
    private FadadaConfig fadadaConfig;

    public FadadaResult registerAccount(String userAccount, String accountType) {
        Validate.notNull((Object)this.fadadaConfig, (String)"\u6cd5\u5927\u5927\u76f8\u5173\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)userAccount, (String)"\u6cd5\u5927\u5927\u6ce8\u518c\u8d26\u53f7\u63a5\u53e3\u7528\u6237\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)accountType, (String)"\u6cd5\u5927\u5927\u6ce8\u518c\u8d26\u53f7\u63a5\u53e3\u8d26\u53f7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        log.info("\u6cd5\u5927\u5927HOST:" + this.fadadaConfig.getHost());
        FddBaseClient fddBaseClient = new FddBaseClient(this.fadadaConfig.getAppId(), this.fadadaConfig.getAppSecret(), this.fadadaConfig.getV(), this.fadadaConfig.getHost());
        RegisterAccountParams params = new RegisterAccountParams();
        params.setAccountType(accountType);
        params.setOpenId(userAccount);
        String result = fddBaseClient.invokeRegisterAccount(params);
        return this.buildFadadaResult(result);
    }

    public FadadaResult findPersonVerifyUrl(String customerId, String verifiedWay, String pageModify) {
        Validate.notNull((Object)this.fadadaConfig, (String)"\u6cd5\u5927\u5927\u76f8\u5173\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)customerId, (String)"\u6cd5\u5927\u5927\u83b7\u53d6\u4e2a\u4eba\u5b9e\u540d\u8ba4\u8bc1\u5730\u5740\u65f6\uff0c\u5ba2\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)verifiedWay, (String)"\u6cd5\u5927\u5927\u83b7\u53d6\u4e2a\u4eba\u5b9e\u540d\u8ba4\u8bc1\u5730\u5740\u65f6\uff0c\u5b9e\u540d\u8ba4\u8bc1\u5957\u9910\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)pageModify, (String)"\u6cd5\u5927\u5927\u83b7\u53d6\u4e2a\u4eba\u5b9e\u540d\u8ba4\u8bc1\u5730\u5740\u65f6\uff0c\u662f\u5426\u5141\u8bb8\u7528\u6237\u9875\u9762\u4fee\u6539\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        log.info("\u6cd5\u5927\u5927HOST:" + this.fadadaConfig.getHost());
        FddVerifyClient client = new FddVerifyClient(this.fadadaConfig.getAppId(), this.fadadaConfig.getAppSecret(), this.fadadaConfig.getV(), this.fadadaConfig.getHost());
        PersonVerifyUrlParams params = new PersonVerifyUrlParams();
        params.setCustomerId(customerId);
        params.setVerifiedWay(verifiedWay);
        params.setPageModify(pageModify);
        params.setReturnUrl(this.fadadaConfig.getAuthReturnUrl());
        params.setNotifyUrl(this.fadadaConfig.getCpsNotifyHost() + "v1/zhangfangyun/fadada/updateAccountStatus");
        String result = client.invokePersonVerifyUrl(params);
        return this.buildFadadaResult(result);
    }

    public FadadaResult findCompanyVerifyUrl(CompanyVerifyUrlDto companyVerifyUrlDto) {
        Validate.notNull((Object)this.fadadaConfig, (String)"\u6cd5\u5927\u5927\u76f8\u5173\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)companyVerifyUrlDto, (String)"\u6cd5\u5927\u5927\u83b7\u53d6\u4f01\u4e1a\u5b9e\u540d\u8ba4\u8bc1\u5730\u5740\u65f6, \u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        FddVerifyClient client = new FddVerifyClient(this.fadadaConfig.getAppId(), this.fadadaConfig.getAppSecret(), this.fadadaConfig.getV(), this.fadadaConfig.getHost());
        CompanyVerifyUrlParams params = new CompanyVerifyUrlParams();
        BeanUtils.copyProperties((Object)companyVerifyUrlDto, (Object)params);
        params.setReturnUrl(this.fadadaConfig.getAuthReturnUrl());
        params.setNotifyUrl(this.fadadaConfig.getCpsNotifyHost() + "v1/zhangfangyun/fadada/updateAccountStatus");
        String result = client.invokeCompanyVerifyUrl(params);
        return this.buildFadadaResult(result);
    }

    public FadadaResult applyCert(String customerId, String transactionNo) {
        Validate.notNull((Object)this.fadadaConfig, (String)"\u6cd5\u5927\u5927\u76f8\u5173\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)customerId, (String)"\u6cd5\u5927\u5927\u5b9e\u540d\u8bc1\u4e66\u7533\u8bf7\u65f6\uff0c\u5ba2\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)transactionNo, (String)"\u6cd5\u5927\u5927\u5b9e\u540d\u8bc1\u4e66\u7533\u8bf7\u65f6\uff0c\u4ea4\u6613\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        FddVerifyClient client = new FddVerifyClient(this.fadadaConfig.getAppId(), this.fadadaConfig.getAppSecret(), this.fadadaConfig.getV(), this.fadadaConfig.getHost());
        ApplyCertParams params = new ApplyCertParams();
        params.setCustomerId(customerId);
        params.setVerifiedSerialNo(transactionNo);
        String result = client.invokeApplyCert(params);
        return this.buildFadadaResult(result);
    }

    public FadadaResult uploadTemplate(String templateId, String docUrl) {
        Validate.notNull((Object)this.fadadaConfig, (String)"\u6cd5\u5927\u5927\u76f8\u5173\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)templateId, (String)"\u6cd5\u5927\u5927\u4e0a\u4f20\u6a21\u677f\u65f6\uff0c\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)docUrl, (String)"\u6cd5\u5927\u5927\u4e0a\u4f20\u6a21\u677f\u65f6\uff0c\u6a21\u677f\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        FddBaseClient client = new FddBaseClient(this.fadadaConfig.getAppId(), this.fadadaConfig.getAppSecret(), this.fadadaConfig.getV(), this.fadadaConfig.getHost());
        UploadTemplateParams params = new UploadTemplateParams();
        params.setTemplateId(templateId);
        params.setDocUrl(docUrl);
        String result = client.invokeUploadTemplate(params);
        return this.buildFadadaResult(result);
    }

    public FadadaResult generateContract(GenerateContractParams generateContractParams) {
        Validate.notNull((Object)this.fadadaConfig, (String)"\u6cd5\u5927\u5927\u76f8\u5173\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)generateContractParams, (String)"\u6cd5\u5927\u5927\u586b\u5145\u6a21\u677f\u65f6\uff0c\u586b\u5145\u6a21\u677f\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        FddBaseClient client = new FddBaseClient(this.fadadaConfig.getAppId(), this.fadadaConfig.getAppSecret(), this.fadadaConfig.getV(), this.fadadaConfig.getHost());
        String result = client.invokeGenerateContract(generateContractParams);
        return this.buildFadadaResult(result);
    }

    public String extSign(ExtSignParams extSignParams) {
        Validate.notNull((Object)this.fadadaConfig, (String)"\u6cd5\u5927\u5927\u76f8\u5173\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)extSignParams, (String)"\u6cd5\u5927\u5927\u624b\u52a8\u7b7e\u7f72\u65f6\uff0c\u624b\u52a8\u7b7e\u7f72\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        FddBaseClient client = new FddBaseClient(this.fadadaConfig.getAppId(), this.fadadaConfig.getAppSecret(), this.fadadaConfig.getV(), this.fadadaConfig.getHost());
        extSignParams.setMobileSignType("2");
        extSignParams.setReturnUrl(this.fadadaConfig.getSignReturnUrl());
        extSignParams.setNotifyUrl(this.fadadaConfig.getCpsNotifyHost() + "v1/zhangfangyun/fadada/updateSignStatus");
        return client.invokeExtSign(extSignParams);
    }

    public FadadaResult extSignAuto(ExtSignAutoParams extSignAutoParams) {
        Validate.notNull((Object)this.fadadaConfig, (String)"\u6cd5\u5927\u5927\u76f8\u5173\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)extSignAutoParams, (String)"\u6cd5\u5927\u5927\u624b\u52a8\u7b7e\u7f72\u65f6\uff0c\u624b\u52a8\u7b7e\u7f72\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        FddBaseClient client = new FddBaseClient(this.fadadaConfig.getAppId(), this.fadadaConfig.getAppSecret(), this.fadadaConfig.getV(), this.fadadaConfig.getHost());
        ExtSignAutoParams params = new ExtSignAutoParams();
        params.setTransactionId(extSignAutoParams.getTransactionId());
        params.setContractId(extSignAutoParams.getContractId());
        params.setCustomerId(extSignAutoParams.getCustomerId());
        params.setDocTitle(extSignAutoParams.getDocTitle());
        params.setPositionType("0");
        params.setSignKeyword("\u7532\u65b9");
        params.setKeywordStrategy("2");
        String result = client.invokeExtSignAuto(params);
        return this.buildFadadaResult(result);
    }

    public String findContractByContractId(String contractId) {
        Validate.notNull((Object)this.fadadaConfig, (String)"\u6cd5\u5927\u5927\u76f8\u5173\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)contractId, (String)"\u6cd5\u5927\u5927\u67e5\u770b\u5408\u540c\u65f6\uff0c\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        FddBaseClient client = new FddBaseClient(this.fadadaConfig.getAppId(), this.fadadaConfig.getAppSecret(), this.fadadaConfig.getV(), this.fadadaConfig.getHost());
        ViewPdfURLParams params = new ViewPdfURLParams();
        params.setContractId(contractId);
        return client.invokeViewPdfURL(params);
    }

    public String downLoadContractByContractId(String contractId) {
        Validate.notNull((Object)this.fadadaConfig, (String)"\u6cd5\u5927\u5927\u76f8\u5173\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)contractId, (String)"\u6cd5\u5927\u5927\u4e0b\u8f7d\u5408\u540c\u65f6\uff0c\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        FddBaseClient client = new FddBaseClient(this.fadadaConfig.getAppId(), this.fadadaConfig.getAppSecret(), this.fadadaConfig.getV(), this.fadadaConfig.getHost());
        DownloadPdfParams params = new DownloadPdfParams();
        params.setContractId(contractId);
        return client.invokeDownloadPdf(params);
    }

    public FadadaResult archiveContractByContractId(String contractId) {
        Validate.notNull((Object)this.fadadaConfig, (String)"\u6cd5\u5927\u5927\u76f8\u5173\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)contractId, (String)"\u6cd5\u5927\u5927\u5f52\u6863\u5408\u540c\u65f6\uff0c\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        FddBaseClient client = new FddBaseClient(this.fadadaConfig.getAppId(), this.fadadaConfig.getAppSecret(), this.fadadaConfig.getV(), this.fadadaConfig.getHost());
        ContractFillingParams params = new ContractFillingParams();
        params.setContractId(contractId);
        String result = client.invokeContractFilling(params);
        return this.buildFadadaResult(result);
    }

    public FadadaResult findPersonCertInfoByTransactionNo(String transactionNo) {
        Validate.notNull((Object)this.fadadaConfig, (String)"\u6cd5\u5927\u5927\u76f8\u5173\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)transactionNo, (String)"\u6cd5\u5927\u5927\u67e5\u770b\u4e2a\u4eba\u5b9e\u540d\u8ba4\u8bc1\u4fe1\u606f\u65f6\uff0c\u4ea4\u6613\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        FddVerifyClient client = new FddVerifyClient(this.fadadaConfig.getAppId(), this.fadadaConfig.getAppSecret(), this.fadadaConfig.getV(), this.fadadaConfig.getHost());
        FindPersonCertParams params = new FindPersonCertParams();
        params.setVerifiedSerialNo(transactionNo);
        String result = client.invokeFindPersonCert(params);
        return this.buildFadadaResult(result);
    }

    public FadadaResult findCompanyCertInfoByTransactionNo(String transactionNo) {
        Validate.notNull((Object)this.fadadaConfig, (String)"\u6cd5\u5927\u5927\u76f8\u5173\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)transactionNo, (String)"\u6cd5\u5927\u5927\u67e5\u770b\u4f01\u4e1a\u5b9e\u540d\u8ba4\u8bc1\u4fe1\u606f\u65f6\uff0c\u4ea4\u6613\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        FddVerifyClient client = new FddVerifyClient(this.fadadaConfig.getAppId(), this.fadadaConfig.getAppSecret(), this.fadadaConfig.getV(), this.fadadaConfig.getHost());
        FindPersonCertParams params = new FindPersonCertParams();
        params.setVerifiedSerialNo(transactionNo);
        String result = client.invokeFindPersonCert(params);
        return this.buildFadadaResult(result);
    }

    public String findAuthSignUrl(String contractId, String customerId, String transactionId) {
        Validate.notNull((Object)this.fadadaConfig, (String)"\u6cd5\u5927\u5927\u76f8\u5173\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)contractId, (String)"\u6cd5\u5927\u5927\u83b7\u53d6\u6388\u6743\u81ea\u52a8\u7b7e\u9875\u9762\u63a5\u53e3\u65f6\uff0c\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)contractId, (String)"\u6cd5\u5927\u5927\u83b7\u53d6\u6388\u6743\u81ea\u52a8\u7b7e\u9875\u9762\u63a5\u53e3\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)contractId, (String)"\u6cd5\u5927\u5927\u83b7\u53d6\u6388\u6743\u81ea\u52a8\u7b7e\u9875\u9762\u63a5\u53e3\u65f6\uff0c\u4ea4\u6613\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        FddBaseClient client = new FddBaseClient(this.fadadaConfig.getAppId(), this.fadadaConfig.getAppSecret(), this.fadadaConfig.getV(), this.fadadaConfig.getHost());
        BeforeAuthSignParams params = new BeforeAuthSignParams();
        params.setTransactionId(transactionId);
        params.setAuthType("1");
        params.setContractId(contractId);
        params.setCustomerId(customerId);
        params.setReturnUrl(this.fadadaConfig.getSignReturnUrl());
        params.setNotifyUrl(this.fadadaConfig.getCpsNotifyHost() + "v1/zhangfangyun/fadada/updateSignStatus");
        return client.invokeBeforeAuthSign(params);
    }

    public String findFileByUuid(String uuid) {
        Validate.notNull((Object)this.fadadaConfig, (String)"\u6cd5\u5927\u5927\u76f8\u5173\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)uuid, (String)"\u6cd5\u5927\u5927\u6839\u636euuid\u83b7\u53d6\u6587\u4ef6\u5730\u5740\u65f6\uff0cuuid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        FddVerifyClient client = new FddVerifyClient(this.fadadaConfig.getAppId(), this.fadadaConfig.getAppSecret(), this.fadadaConfig.getV(), this.fadadaConfig.getHost());
        FileForUUIDParams params = new FileForUUIDParams();
        params.setUuid(uuid);
        params.setDocType("0");
        return client.invokeFileForUUID(params);
    }

    private FadadaResult buildFadadaResult(String result) {
        if (StringUtils.isBlank((CharSequence)result)) {
            throw new RuntimeException("\u6cd5\u5927\u5927\u63a5\u53e3\u5931\u8d25\uff01");
        }
        FadadaResult fadadaResult = (FadadaResult)JSONObject.parseObject((String)result, FadadaResult.class);
        if (!"1".equals(fadadaResult.getCode()) && !"1000".equals(fadadaResult.getCode())) {
            throw new RuntimeException(fadadaResult.getMsg());
        }
        return fadadaResult;
    }
}

