/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.cash.zhangfangyun.local.service.observer;

import com.biz.crm.cps.business.cash.sdk.common.enums.CashStatusEnum;
import com.biz.crm.cps.business.cash.sdk.dto.CashConditionDto;
import com.biz.crm.cps.business.cash.sdk.dto.CashRecordDto;
import com.biz.crm.cps.business.cash.sdk.service.CashRecordVoService;
import com.biz.crm.cps.business.cash.sdk.service.observer.CashMountRegister;
import com.biz.crm.cps.business.cash.sdk.service.observer.CashServiceObserver;
import com.biz.crm.cps.business.cash.sdk.vo.CashProcessVo;
import com.biz.crm.cps.business.cash.sdk.vo.CashRecordVo;
import com.biz.crm.cps.external.cash.zhangfangyun.local.entity.ContractSign;
import com.biz.crm.cps.external.cash.zhangfangyun.local.entity.ContractTemplate;
import com.biz.crm.cps.external.cash.zhangfangyun.local.entity.FadadaAccount;
import com.biz.crm.cps.external.cash.zhangfangyun.local.service.ContractSignService;
import com.biz.crm.cps.external.cash.zhangfangyun.local.service.ContractTemplateService;
import com.biz.crm.cps.external.cash.zhangfangyun.local.service.FadadaAccountService;
import com.biz.crm.cps.external.cash.zhangfangyun.sdk.common.enums.FadadaAccountTypeEnum;
import com.biz.crm.cps.external.cash.zhangfangyun.sdk.common.enums.FadadaCompanyVerifyStatusEnum;
import com.biz.crm.cps.external.cash.zhangfangyun.sdk.common.enums.FadadaPersonVerifyStatusEnum;
import com.biz.crm.cps.external.cash.zhangfangyun.sdk.common.enums.FadadaSignStatusEnum;
import com.biz.crm.cps.external.cash.zhangfangyun.sdk.dto.ContractTemplatePdfParamsDto;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ZhangFangYunCashServiceObserverImpl
implements CashServiceObserver {
    @Autowired
    @Qualifier(value="ZhangFangYunCashMountRegisterImpl")
    private CashMountRegister cashMountRegister;
    @Autowired
    private FadadaAccountService fadadaAccountService;
    @Autowired(required=false)
    private CashRecordVoService cashRecordVoService;
    @Autowired
    private ContractSignService contractSignService;
    @Autowired
    private ContractTemplateService contractTemplateService;

    public CashProcessVo onRequestCashProcess(CashConditionDto cashCondition) {
        if (Objects.isNull(cashCondition) || !Objects.equals(cashCondition.getCashKey(), this.cashMountRegister.getKey())) {
            return null;
        }
        CashProcessVo vo = new CashProcessVo();
        vo.setFlag(this.cashMountRegister.getFlag());
        vo.setKey(this.cashMountRegister.getKey());
        vo.setName(this.cashMountRegister.getName());
        FadadaAccount account = this.fadadaAccountService.findByUserAccountAndUserType(cashCondition.getPayeeCode(), cashCondition.getParticipatorFlag());
        boolean needVerify = this.requiredAgainVerify(account);
        vo.setNeedVerify(needVerify);
        if (!needVerify) {
            this.requiredContractSign(vo, account);
        } else {
            String url = null;
            url = account == null ? this.createVerifyUrl(cashCondition) : account.getVerifyUrl();
            vo.setVerifyUrl(url);
            vo.setNeedSign(true);
        }
        return vo;
    }

    @Transactional
    public CashProcessVo onCreateContract(CashConditionDto cashCondition) {
        return null;
    }

    @Transactional
    public CashRecordVo onCash(CashConditionDto cashCondition) {
        Validate.notNull((Object)cashCondition, (String)"\u5151\u4ed8\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)cashCondition.getAmount(), (String)"\u5151\u4ed8\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((cashCondition.getAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u5151\u4ed8\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        if (Objects.equals(cashCondition.getCashKey(), this.cashMountRegister.getKey())) {
            CashRecordDto cashRecordDto = new CashRecordDto();
            cashRecordDto.setAmount(cashCondition.getAmount());
            cashRecordDto.setParticipatorCode(cashCondition.getParticipatorCode());
            cashRecordDto.setParticipatorType(cashCondition.getParticipatorFlag());
            cashRecordDto.setParticipatorName(cashCondition.getParticipatorName());
            cashRecordDto.setCashMethodKey(this.cashMountRegister.getKey());
            cashRecordDto.setCashMethodName(this.cashMountRegister.getName());
            cashRecordDto.setCashStatus(CashStatusEnum.NO_PAID.getDictCode());
            cashRecordDto.setRewardKey(cashCondition.getRewardKey());
            cashRecordDto.setRewardName(cashCondition.getRewardName());
            cashRecordDto.setPayeeName(cashCondition.getPayeeName());
            cashRecordDto.setPayeePhone(cashCondition.getPayeePhone());
            cashRecordDto.setPayeeCode(cashCondition.getPayeeCode());
            CashRecordVo cashRecordVo = this.cashRecordVoService.create(cashRecordDto);
            return cashRecordVo;
        }
        return null;
    }

    private boolean requiredAgainVerify(FadadaAccount account) {
        if (account == null) {
            return true;
        }
        return (!Objects.equals(account.getAccountType(), FadadaAccountTypeEnum.PERSON.getDictCode()) || !Objects.equals(account.getStatus(), FadadaPersonVerifyStatusEnum.PASSED.getDictCode())) && (!Objects.equals(account.getAccountType(), FadadaAccountTypeEnum.COMPANY.getDictCode()) || !Objects.equals(account.getStatus(), FadadaCompanyVerifyStatusEnum.PASSED.getDictCode()));
    }

    private String createVerifyUrl(CashConditionDto cashCondition) {
        String loginAccount = cashCondition.getPayeeCode();
        String userType = cashCondition.getParticipatorFlag();
        FadadaAccount account = new FadadaAccount();
        account.setUserName(cashCondition.getPayeeName());
        account.setUserAccount(loginAccount);
        account.setUserType(userType);
        account.setAccountType(FadadaAccountTypeEnum.PERSON.getDictCode());
        account = this.fadadaAccountService.create(account);
        return account.getVerifyUrl();
    }

    private String findContractSignUrl(FadadaAccount account) {
        if (account == null) {
            return null;
        }
        ContractTemplate contractTemplate = this.contractTemplateService.findTopOne();
        Validate.notNull((Object)((Object)contractTemplate), (String)"\u672a\u67e5\u8be2\u5230\u5408\u540c\u6a21\u677f\uff01", (Object[])new Object[0]);
        ContractSign contractSign = new ContractSign();
        contractSign.setCustomerId(account.getCustomerId());
        contractSign.setTemplateId(contractTemplate.getTemplateId());
        contractSign.setDocTitle("\u4e2a\u4f53\u5de5\u5546\u4e1a\u8005\u670d\u52a1\u5408\u540c");
        ContractTemplatePdfParamsDto paramsDto = new ContractTemplatePdfParamsDto();
        paramsDto.setSoho(account.getPersonName());
        paramsDto.setContact(account.getMobile());
        paramsDto.setDateOfSigning(DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd"));
        paramsDto.setIdCard(account.getIdCard());
        paramsDto.setOfficesCloud("\u56db\u5ddd\u8d26\u623f\u4e91\u79d1\u6280\u6709\u9650\u516c\u53f8");
        paramsDto.setWisdomOfClouds("\u6210\u90fd\u667a\u817e\u4e91\u79d1\u6280\u6709\u9650\u516c\u53f8");
        contractSign.setParamsDto(paramsDto);
        contractSign.setContractName(contractTemplate.getTemplateName() + account.getUserAccount());
        ContractSign sign = this.contractSignService.create(contractSign);
        return sign.getSignUrl();
    }

    private void requiredContractSign(CashProcessVo vo, FadadaAccount account) {
        ContractTemplate contractTemplate = this.contractTemplateService.findTopOne();
        Validate.notNull((Object)((Object)contractTemplate), (String)"\u672a\u67e5\u8be2\u5230\u5408\u540c\u6a21\u677f\uff01", (Object[])new Object[0]);
        ContractSign contractSign = this.contractSignService.findByCustomerIdAndTemplateId(account.getCustomerId(), contractTemplate.getTemplateId());
        vo.setNeedSign(false);
        if (contractSign != null) {
            if (!FadadaSignStatusEnum.SIGN.getDictCode().equals(contractSign.getSignStatus())) {
                vo.setContractSignUrl(contractSign.getSignUrl());
                vo.setNeedSign(true);
            }
        } else {
            String contractSignUrl = this.findContractSignUrl(account);
            vo.setContractSignUrl(contractSignUrl);
            vo.setNeedSign(true);
        }
    }
}

