package com.biz.crm.cps.feign.customer.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.feign.customer.local.feign.CustomerVoFeign;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerSelectDto;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;

/**
 * 客户信息VO服务接口实现类
 *
 * @author ning.zhang
 * @date 2022/2/21
 */
@Service("FeignCustomerVoServiceImpl")
public class CustomerVoServiceImpl implements CustomerVoService {

  @Autowired
  private CustomerVoFeign customerVoFeign;

  @Override
  public CustomerVo findDetailsByIdOrCode(String id, String customerCode) {
    throw new UnsupportedOperationException();
  }

  @Override
  public Page<CustomerVo> findByCustomerSelectDto(Pageable pageable, CustomerSelectDto dto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public List<CustomerVo> findByOrgCodes(List<String> orgCodeList) {
    throw new UnsupportedOperationException();
  }

  @Override
  public List<CustomerVo> findByCustomerCodes(List<String> customerCodeList) {
    return this.customerVoFeign.findByCustomerCodes(customerCodeList).getResult();
  }

  @Override
  public List<CustomerVo> findByChannels(List<String> channelList) {
    throw new UnsupportedOperationException();
  }

  @Override
  public List<CustomerVo> findByTypes(List<String> typeList) {
    throw new UnsupportedOperationException();
  }

  @Override
  public Set<String> findCustomerCodesByOrgCodesAndChannelsAndTags(List<String> orgCodes, List<String> channels, List<String> tags) {
    return this.customerVoFeign.findCustomerCodesByOrgCodesAndChannelsAndTags(orgCodes, channels, tags).getResult();
  }
}
