package com.biz.crm.cps.feign.customer.user.local.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.cps.feign.customer.user.local.feign.internal.CustomerUserVoFeignImpl;
import com.biz.crm.mdm.business.customer.user.sdk.vo.CustomerUserVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 客户用户feign接口类
 *
 * @author ning.zhang
 * @date 2022/2/18
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = CustomerUserVoFeignImpl.class)
public interface CustomerUserVoFeign {

  /**
   * 通过用户手机号获取客户用户信息(包含经客户信息)
   *
   * @param userPhone 用户手机号
   * @return
   */
  @ApiOperation(value = "通过用户手机号获取客户用户信息(包含经客户信息)")
  @GetMapping(value = {"/v1/customerUser/customerUser/findDetailsByUserPhone"})
  Result<CustomerUserVo> findDetailsByUserPhone(@RequestParam("userPhone") String userPhone);
}
