package com.biz.crm.cps.feign.customer.user.local.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.cps.feign.customer.user.local.feign.CustomerUserVoFeign;
import com.biz.crm.mdm.business.customer.user.sdk.vo.CustomerUserVo;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 客户用户feign接口熔断类
 *
 * @author ning.zhang
 * @date 2022/2/18
 */
@Slf4j
@Component
public class CustomerUserVoFeignImpl implements FallbackFactory<CustomerUserVoFeign> {
  @Override
  public CustomerUserVoFeign create(Throwable throwable) {
    return new CustomerUserVoFeign() {
      @Override
      public Result<CustomerUserVo> findDetailsByUserPhone(String userPhone) {
        throw new UnsupportedOperationException("通过用户手机号获取客户用户信息熔断");
      }
    };
  }
}
