package com.biz.crm.cps.feign.terminal.local.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.cps.feign.terminal.local.feign.internal.TerminalSupplyVoFeignImpl;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalSupplyVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Set;

/**
 * 供货关系feign接口类
 *
 * @author ning.zhang
 * @date 2022/2/18
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = TerminalSupplyVoFeignImpl.class)
public interface TerminalSupplyVoFeign {

  /**
   * 获取终端指定物料的供货经销商编码集合
   *
   * @param terminalCode
   * @param materialCode
   * @returnø
   */
  @GetMapping(value = {"/v1/terminal/terminalSupply/findTerminalSupplyCustomerCodeSet"})
  Result<Set<String>> findTerminalSupplyCustomerCodeSet(
      @RequestParam("terminalCode") String terminalCode,
      @RequestParam("materialCode") String materialCode);

  /**
   * 根据终端编码集合获取匹配信息
   *
   * @param codes
   * @return
   */
  @ApiOperation(value = "根据终端编码集合获取匹配信息")
  @GetMapping(value = {"/v1/terminal/terminalSupply/findByTerminalCodes"})
  Result<List<TerminalSupplyVo>> findByTerminalCodes(@RequestParam("codes") List<String> codes);
}
