package com.biz.crm.cps.feign.terminal.local.feign;

import antlr.debug.SemanticPredicateEvent;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.cps.feign.terminal.local.feign.internal.TerminalVoFeignImpl;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalCodeSearchDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalPaginationDto;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Set;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 终端feign接口类
 *
 * @author ning.zhang
 * @date 2022/2/18
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = TerminalVoFeignImpl.class)
public interface TerminalVoFeign {

  /**
   * 分页条件查询
   *
   * @param dto 参数dto
   * @return 终端分页信息
   */
  @ApiOperation(value = "分页条件查询")
  @GetMapping(value = {"/v1/terminal/terminal/findByTerminalPaginationDto"})
  Result<Page<TerminalVo>> findByTerminalPaginationDto(
      @RequestParam("page") Integer page,
      @RequestParam("size") Integer size,
      @SpringQueryMap TerminalPaginationDto dto);

  /**
   * 根据组织、渠道、标签获取匹配的终端编码
   *
   * @param dto
   * @return
   */
  @PostMapping(value = {"/v1/terminal/terminal/findByTerminalCodeSearchDto"})
  Result<Set<String>> findByTerminalCodeSearchDto(@RequestBody TerminalCodeSearchDto dto);

  /**
   * 根据编码获取终端主信息+组织信息
   *
   * @param terminalCodeList
   * @return
   */
  @GetMapping(value = {"/v1/terminal/terminal/findMainDetailsByTerminalCodes"})
  Result<List<TerminalVo>> findMainDetailsByTerminalCodes(
      @RequestParam("terminalCodeList") List<String> terminalCodeList);
}
