package com.biz.crm.cps.feign.terminal.local.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.cps.feign.terminal.local.feign.TerminalSupplyVoFeign;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalSupplyVo;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;

/**
 * 供货关系feign接口类实现
 *
 * @author sunx
 * @date 2022/3/14
 */
@Component
@Slf4j
public class TerminalSupplyVoFeignImpl implements FallbackFactory<TerminalSupplyVoFeign> {

  @Override
  public TerminalSupplyVoFeign create(Throwable cause) {
    return new TerminalSupplyVoFeign() {
      @Override
      public Result<Set<String>> findTerminalSupplyCustomerCodeSet(
          String terminalCode, String materialCode) {
        throw new UnsupportedOperationException("获取终端指定物料的供货经销商编码集合ø熔断");
      }

      @Override
      public Result<List<TerminalSupplyVo>> findByTerminalCodes(List<String> codes) {
        throw new UnsupportedOperationException("根据终端编码集合获取匹配信息ø熔断");
      }
    };
  }
}
