package com.biz.crm.cps.feign.terminal.local.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.cps.feign.terminal.local.feign.TerminalTagVoFeign;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalTagVo;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;

/**
 * 终端标签feign接口熔断类
 *
 * @author songjingen
 */
@Slf4j
@Component
public class TerminalTagVoFeignImpl implements FallbackFactory<TerminalTagVoFeign> {
  @Override
  public TerminalTagVoFeign create(Throwable throwable) {
    return new TerminalTagVoFeign() {
      @Override
      public Result<List<TerminalTagVo>> findByTerminalCodes(Set<String> terminalCodes) {
        throw new UnsupportedOperationException("通过终端编码查询标签列表熔断");
      }
    };
  }
}
