package com.biz.crm.cps.feign.terminal.local.feign.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.cps.feign.terminal.local.feign.TerminalVoFeign;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalCodeSearchDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalPaginationDto;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import feign.hystrix.FallbackFactory;
import java.util.List;
import java.util.Set;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 终端feign接口熔断类
 *
 * @author ning.zhang
 * @date 2022/2/22
 */
@Slf4j
@Component
public class TerminalVoFeignImpl implements FallbackFactory<TerminalVoFeign> {
  @Override
  public TerminalVoFeign create(Throwable throwable) {
    return new TerminalVoFeign() {
      @Override
      public Result<Page<TerminalVo>> findByTerminalPaginationDto(
          Integer page, Integer size, TerminalPaginationDto dto) {
        throw new UnsupportedOperationException("终端分页条件查询熔断");
      }

      @Override
      public Result<Set<String>> findByTerminalCodeSearchDto(TerminalCodeSearchDto dto) {
        throw new UnsupportedOperationException("根据组织、渠道、标签获取匹配的终端编码熔断");
      }

      @Override
      public Result<List<TerminalVo>> findMainDetailsByTerminalCodes(
          List<String> terminalCodeList) {
        throw new UnsupportedOperationException("根据编码获取终端主信息+组织信息熔断");
      }
    };
  }
}
