package com.biz.crm.cps.feign.terminal.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.feign.terminal.local.feign.TerminalVoFeign;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalCodeSearchDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalPaginationDto;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * 终端信息Vo接口实现类
 *
 * @author ning.zhang
 * @date 2022/2/22
 */
@Service("FeignTerminalVoServiceImpl")
public class TerminalVoServiceImpl implements TerminalVoService {

  @Autowired private TerminalVoFeign terminalVoFeign;

  @Override
  public List<TerminalVo> findDetailsByIdsOrTerminalCodes(
      List<String> ids, List<String> terminalCodes) {
    throw new UnsupportedOperationException();
  }

  @Override
  public TerminalVo create(TerminalDto dto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public TerminalVo update(TerminalDto dto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public Page<TerminalVo> findByTerminalPaginationDto(
      Pageable pageable, TerminalPaginationDto dto) {
    return this.terminalVoFeign
        .findByTerminalPaginationDto(pageable.getPageNumber(), pageable.getPageSize(), dto)
        .getResult();
  }

  @Override
  public Set<String> findByTerminalCodeSearchDto(TerminalCodeSearchDto dto) {
    return this.terminalVoFeign.findByTerminalCodeSearchDto(dto).getResult();
  }

  @Override
  public List<TerminalVo> findMainDetailsByTerminalCodes(List<String> terminalCodeList) {
    return this.terminalVoFeign.findMainDetailsByTerminalCodes(terminalCodeList).getResult();
  }
}
