package com.biz.crm.cps.feign.terminal.user.local.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.cps.feign.terminal.user.local.feign.internal.TerminalUserVoFeignImpl;
import com.biz.crm.mdm.business.terminal.user.sdk.vo.TerminalUserVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 终端用户feign接口类
 *
 * @author ning.zhang
 * @date 2022/2/18
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = TerminalUserVoFeignImpl.class)
public interface TerminalUserVoFeign {

  /**
   * 通过用户手机号获取终端用户信息
   *
   * @param userPhone 用户手机号
   * @return 终端用户信息
   */
  @GetMapping(value = {"/v1/terminalUser/terminalUser/findByUserPhone"})
  Result<TerminalUserVo> findByUserPhone(@RequestParam("userPhone") String userPhone);

  /**
   * 根据编码获取集合
   *
   * @param userCodes
   * @return
   */
  @ApiOperation(value = "通过用户编码获取终端用户信息")
  @GetMapping(value = {"/v1/terminalUser/terminalUser/findDetailsByUserCodes"})
  Result<List<TerminalUserVo>> findDetailsByUserCodes(@RequestParam("userCodes") List<String> userCodes);

}
