package com.biz.crm.cps.feign.upload.local.feign;

import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.feign.upload.local.feign.internal.UploadVoFeignFallbackImpl;
import com.biz.crm.cps.feign.upload.sdk.vo.UploadVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 上传文件feign
 *
 * @author songjingen
 */
@FeignClient(
    name = "${feign.urlip:crm-upload}",
    path = "upload",
    fallbackFactory = UploadVoFeignFallbackImpl.class
)
public interface UploadVoFeign {


  /**
   * 上传文件feign接口
   *
   * @param file 文件信息
   * @return 返回文件上传结果信息
   */
  @PostMapping(value = "/uploadController/uploadOss", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
  Result<List<UploadVo>> uploadOss(@RequestPart(value = "file", required = false) MultipartFile file);
}
