package com.biz.crm.cps.feign.upload.local.feign.internal;

import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.feign.upload.local.feign.UploadVoFeign;
import com.biz.crm.cps.feign.upload.sdk.vo.UploadVo;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 协防计划制定 feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-09-21 14:35:05
 */
@Slf4j
@Component
public class UploadVoFeignFallbackImpl implements FallbackFactory<UploadVoFeign> {

  @Override
  public UploadVoFeign create(Throwable throwable) {
    return new UploadVoFeign() {
      @Override
      public Result<List<UploadVo>> uploadOss(MultipartFile file) {
        throw new UnsupportedOperationException("上传文件熔断");
      }
    };
  }
}
