package com.biz.crm.cps.feign.upload.local.service.internal;

import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.feign.upload.local.feign.UploadVoFeign;
import com.biz.crm.cps.feign.upload.sdk.service.UploadVoService;
import com.biz.crm.cps.feign.upload.sdk.vo.UploadVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 上传文件接口实现类
 *
 * @author ning.zhang
 * @date 2022/2/15
 */
@Service("FeignUploadVoServiceImpl")
public class UploadVoServiceImpl implements UploadVoService {

  @Autowired
  private UploadVoFeign uploadVoFeign;

  @Override
  public List<UploadVo> uploadOss(MultipartFile file) {
    Result<List<UploadVo>> result = this.uploadVoFeign.uploadOss(file);
    return result.getResult();
  }
}
