package com.biz.crm.cps.feign.upload.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 文件路上传信息
 *
 * @author ning.zhang
 * @date 2022/2/18
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel("文件路上传信息")
public class UploadVo implements Serializable {

  private static final long serialVersionUID = 4831689394028774329L;

  @ApiModelProperty(value = "访问前缀")
  private String urlPathPrefix;
  @ApiModelProperty(value = "路径")
  private String urlPath;
  @ApiModelProperty(value = "访问路径")
  private String url;
  @ApiModelProperty(value = "文件名称")
  private String fileName;
  @ApiModelProperty(value = "对象名")
  private String objectName;
  @ApiModelProperty(value = "文件后缀")
  private String suffix;
}
