package com.biz.crm.cps.feign.user.local.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.cps.feign.user.local.feign.internal.UserVoFeignFallbackImpl;
import com.biz.crm.mdm.business.user.sdk.dto.UserFeignDto;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Set;

/**
 * 用户信息feign接口类
 *
 * @author songjingen
 * @date 2022/3/2
 */
@FeignClient(
    name = "${feign.urlip:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = UserVoFeignFallbackImpl.class
)
public interface UserVoFeign {

  /**
   * 根据组织编码集合和职位级别集合和用户类型查询编码集合
   * 注意orgCodes和positionLevelCodes只允许有一个为空,否则返回空
   *
   * @param orgCodes           组织编码集合
   * @param positionLevelCodes 职位级别编码集合
   * @param userType           用户类型
   * @return 登录用户编码集合
   */
  @ApiOperation(value = "根据组织编码集合和职位级别集合和用户类型查询编码集合")
  @GetMapping(value = {"/v1/user/user/findUserNamesByCodesAndUserType"})
  Result<Set<String>> findUserNamesByCodesAndUserType(@RequestParam(value = "orgCodes", required = false) List<String> orgCodes,
                                                             @RequestParam(value = "positionLevelCodes", required = false) List<String> positionLevelCodes,
                                                             @RequestParam(value = "userType") String userType);
  /**
   * 按用户账号查询集合(包含职位和组织)
   *
   * @param userNames 用户帐号集合
   * @return 用户信息集合
   */
  @ApiOperation(value = "按用户账号查询集合(包含职位和组织)")
  @GetMapping(value = {"/v1/user/user/findByUserNames"})
  Result<List<UserVo>> findByUserNames(@RequestParam(value = "userNames") List<String> userNames);

  /**
   * 按照用户手机号查询用户信息(包含职位和组织)
   *
   * @param phone 用户手机号
   * @return 用户信息
   */
  @ApiOperation(value = "按用户账号查询集合(包含职位和组织)")
  @GetMapping(value = {"/v1/user/user/findDetailsByPhone"})
  Result<UserVo> findDetailsByPhone(@RequestParam(value = "phone") String phone);

  /**
   * 按照条件查询用户账号集合
   *
   * @param dto 查询集合
   * @return 用户账号信息集合
   */
  @ApiOperation(value = "按照条件查询用户账号集合")
  @PostMapping(value = {"/v1/user/user/findUserNamesByUserDto"})
  Result<Set<String>> findUserNamesByUserDto(@RequestBody UserFeignDto dto);

}
