package com.biz.crm.cps.feign.user.local.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.cps.feign.user.local.feign.UserVoFeign;
import com.biz.crm.mdm.business.user.sdk.dto.UserFeignDto;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;

/**
 * 用户信息feign接口熔断类
 *
 * @author songjingen
 * @date 2022/3/2
 */
@Slf4j
@Component
public class UserVoFeignFallbackImpl implements FallbackFactory<UserVoFeign> {
  @Override
  public UserVoFeign create(Throwable throwable) {
    return new UserVoFeign() {
      @Override
      public Result<Set<String>> findUserNamesByCodesAndUserType(List<String> orgCodes, List<String> positionLevelCodes, String userType) {
        throw new UnsupportedOperationException("根据组织编码集合和职位级别集合和用户类型查询编码集合熔断");
      }

      @Override
      public Result<List<UserVo>> findByUserNames(List<String> userNames) {
        throw new UnsupportedOperationException("根据用户账号集合查询熔断");
      }

      @Override
      public Result<UserVo> findDetailsByPhone(String phone) {
        throw new UnsupportedOperationException("按照用户手机号查询用户信息(包含职位和组织)熔断");
      }

      @Override
      public Result<Set<String>> findUserNamesByUserDto(UserFeignDto dto) {
        throw new UnsupportedOperationException("按照条件查询用户账号集合熔断");
      }

    };
  }
}
