/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.quantify.local.service.builder;

import com.biz.crm.cps.bisiness.policy.quantify.sdk.constant.QuantifyTaskStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.common.local.utils.DateUtils;
import com.biz.crm.cps.business.policy.quantify.local.entity.QuantifyPolicy;
import com.biz.crm.cps.business.policy.quantify.local.entity.QuantifyTask;
import com.biz.crm.cps.business.policy.quantify.local.service.builder.QuantifyTaskBuilder;
import com.biz.crm.cps.business.policy.quantify.local.utils.QuantifyUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class QuantifyTaskMonthBuilder
implements QuantifyTaskBuilder {
    @Override
    public List<QuantifyTask> assemblyQuantifyTask(AgreementVo agreementVo, QuantifyPolicy quantifyPolicy) {
        ArrayList taskList = Lists.newArrayList();
        Date effectiveTime = agreementVo.getEffectiveStartTime();
        Date now = new Date();
        QuantifyTaskStatusEnum statusEnum = QuantifyTaskStatusEnum.STATUS_WAIT;
        if (effectiveTime.before(now)) {
            effectiveTime = now;
            statusEnum = QuantifyTaskStatusEnum.STATUS_DOING;
        }
        while (effectiveTime.before(agreementVo.getEffectiveEndTime())) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(effectiveTime);
            int nowMonth = calendar.get(2) + 1;
            int nowYear = calendar.get(1);
            effectiveTime = DateUtils.addMonthFirstTime((Date)effectiveTime, (int)1);
            QuantifyTask quantifyTask = new QuantifyTask();
            quantifyTask.setTaskStartTime(effectiveTime);
            quantifyTask.setTaskEndTime(DateUtils.addMonthLastTime((Date)effectiveTime, (int)0));
            quantifyTask.setTaskName(nowYear + "\u5e74\u7b2c" + nowMonth + "\u6708\u5305\u91cf\u4efb\u52a1");
            quantifyTask.setTaskStatus(statusEnum.getCode());
            quantifyTask.setSaleTarget(QuantifyUtils.getScaleByMonth(nowMonth, quantifyPolicy));
            taskList.add(quantifyTask);
            statusEnum = QuantifyTaskStatusEnum.STATUS_WAIT;
        }
        return taskList;
    }
}

