/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.quantify.local.service.internal;

import com.biz.crm.cps.bisiness.policy.quantify.sdk.dto.QuantifyPolicyDto;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementPolicyDto;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.policy.quantify.local.entity.QuantifyExpression;
import com.biz.crm.cps.business.policy.quantify.local.entity.QuantifyPolicy;
import com.biz.crm.cps.business.policy.quantify.local.entity.QuantifyRange;
import com.biz.crm.cps.business.policy.quantify.local.repository.QuantifyConfigurationRepository;
import com.biz.crm.cps.business.policy.quantify.local.repository.QuantifyExpressionRepository;
import com.biz.crm.cps.business.policy.quantify.local.repository.QuantifyPolicyRepository;
import com.biz.crm.cps.business.policy.quantify.local.repository.QuantifyRangeRepository;
import com.biz.crm.cps.business.policy.quantify.local.service.QuantifyPolicyService;
import com.biz.crm.cps.business.policy.quantify.local.service.observer.QuantifyPolicyPojoObserverImpl;
import com.bizunited.platform.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class QuantifyPolicyServiceImpl
implements QuantifyPolicyService {
    @Autowired
    private QuantifyPolicyPojoObserverImpl policyPojoObserver;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private QuantifyPolicyRepository quantifyPolicyRepository;
    @Autowired
    private QuantifyConfigurationRepository quantifyConfigurationRepository;
    @Autowired
    private QuantifyRangeRepository quantifyRangeRepository;
    @Autowired
    private QuantifyExpressionRepository quantifyExpressionRepository;
    @Autowired
    private LoginUserService loginUserService;

    @Override
    @Transactional
    public QuantifyPolicy create(AgreementPolicyDto agreementPolicyDto) {
        if (agreementPolicyDto == null) {
            return null;
        }
        QuantifyPolicy quantifyPolicy = (QuantifyPolicy)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)((QuantifyPolicyDto)agreementPolicyDto), QuantifyPolicy.class, Set.class, ArrayList.class, new String[]{"quantifyConfigurations"}));
        return this.createFrom(quantifyPolicy);
    }

    @Override
    @Transactional
    public QuantifyPolicy createFrom(QuantifyPolicy quantifyPolicy) {
        this.createValidation(quantifyPolicy);
        Date now = new Date();
        quantifyPolicy.setCreateTime(now);
        quantifyPolicy.setModifyTime(now);
        quantifyPolicy.setCreateAccount(this.loginUserService.getLoginAccountName());
        quantifyPolicy.setModifyAccount(this.loginUserService.getLoginAccountName());
        this.quantifyPolicyRepository.save((Object)quantifyPolicy);
        quantifyPolicy.getQuantifyConfigurations().forEach(quantifyConfiguration -> {
            quantifyConfiguration.setQuantifyPolicyId(quantifyPolicy.getId());
            this.quantifyConfigurationRepository.save(quantifyConfiguration);
            quantifyConfiguration.getQuantifyExpressions().forEach(quantifyExpression -> quantifyExpression.setConfigurationId(quantifyConfiguration.getId()));
            this.quantifyExpressionRepository.saveBatch(quantifyConfiguration.getQuantifyExpressions());
            quantifyConfiguration.getQuantifyRanges().forEach(quantifyRange -> quantifyRange.setConfigurationId(quantifyConfiguration.getId()));
            this.quantifyRangeRepository.saveBatch(quantifyConfiguration.getQuantifyRanges());
        });
        return quantifyPolicy;
    }

    @Override
    public QuantifyPolicy findById(String id) {
        return this.quantifyPolicyRepository.findDetailById(id);
    }

    @Override
    public QuantifyPolicy findByTemplateCode(String templateCode) {
        return this.quantifyPolicyRepository.findDetailByTemplateCode(templateCode);
    }

    private void createValidation(QuantifyPolicy entity) {
        Validate.notNull((Object)((Object)entity), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)entity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        entity.setId(null);
        Validate.notBlank((CharSequence)entity.getTenantCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(entity.getQuantifyConfigurations()) ? 1 : 0) != 0, (String)"\u653f\u7b56\u914d\u7f6e\u884c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        entity.getQuantifyConfigurations().forEach(quantifyConfiguration -> {
            Validate.notBlank((CharSequence)quantifyConfiguration.getDimensionFlag(), (String)"\u4ea7\u54c1\u7ef4\u5ea6\u6807\u8bb0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)quantifyConfiguration.getDimensionName(), (String)"\u4ea7\u54c1\u7ef4\u5ea6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((!CollectionUtils.isEmpty(quantifyConfiguration.getQuantifyRanges()) ? 1 : 0) != 0, (String)"\u653f\u7b56\u5173\u8054\u4ea7\u54c1\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((!CollectionUtils.isEmpty(quantifyConfiguration.getQuantifyExpressions()) ? 1 : 0) != 0, (String)"\u653f\u7b56\u5173\u8054\u5206\u5229\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            quantifyConfiguration.getQuantifyRanges().forEach(this::quantifyRangeValidation);
            quantifyConfiguration.getQuantifyExpressions().forEach(this::quantifyExpressionValidation);
        });
    }

    private void quantifyExpressionValidation(QuantifyExpression entity) {
        Validate.notNull((Object)((Object)entity), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)entity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        entity.setId(null);
        Validate.notBlank((CharSequence)entity.getRewardMethodFlag(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5956\u52b1\u65b9\u5f0f\u6807\u5fd7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getRewardMethodName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5956\u52b1\u65b9\u5f0f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getReachRate(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u9636\u68af\u8fbe\u6210\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((entity.getReachRate().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u9636\u68af\u8fbe\u6210\u6bd4\u4f8b\u5fc5\u987b\u5927\u4e8e0\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getRewardData(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5956\u52b1\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((entity.getRewardData().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u5956\u52b1\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0\uff01", (Object[])new Object[0]);
    }

    private void quantifyRangeValidation(QuantifyRange entity) {
        Validate.notNull((Object)((Object)entity), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)entity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        entity.setId(null);
        Validate.notBlank((CharSequence)entity.getDimensionCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4ea7\u54c1\u7ef4\u5ea6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getDimensionName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4ea7\u54c1\u7ef4\u5ea6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

