/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.local.interceptor;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class CrmSecurityAuthorizationFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(CrmSecurityAuthorizationFilter.class);
    @Autowired
    private LoginUserService loginUserService;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            String obj = request.getHeader("NON_WEB_REQUEST");
            if (obj != null) {
                JSONObject authorizationVo = JSONObject.parseObject((String)obj);
                String tenantCode = authorizationVo.getString("tenantCode");
                Validate.notBlank((CharSequence)tenantCode, (String)"tenatCode is blank!", (Object[])new Object[0]);
                String account = authorizationVo.getString("account");
                Validate.notBlank((CharSequence)account, (String)"account is blank!", (Object[])new Object[0]);
                JSONArray roles = authorizationVo.getJSONArray("roles");
                Validate.isTrue((!CollectionUtils.isEmpty((Collection)roles) ? 1 : 0) != 0, (String)"roles is empty!", (Object[])new Object[0]);
                LoginUserDetails loginUserDetails = new LoginUserDetails(request);
                loginUserDetails.setTenantCode(tenantCode);
                loginUserDetails.setAccount(account);
                loginUserDetails.setRoles(Lists.newArrayList((Object[])roles.toArray((Object[])new String[0])));
                this.loginUserService.refreshLogin(loginUserDetails);
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            log.error("SecurityAuthorizationFilter Error\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
    }
}

