/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.local.interceptor;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleDatetimeExpr;
import com.alibaba.druid.util.StringUtils;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.bizunited.nebula.common.repository.interceptor.NebulaRepositoryInterceptorStrategy;
import com.bizunited.nebula.common.repository.interceptor.SqlCommandType;
import com.bizunited.nebula.security.sdk.vo.LoginDetails;
import java.sql.Connection;
import java.sql.SQLSyntaxErrorException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.stereotype.Component;

@Component
public class DefaultMybatisBaseFieldEnhanceInterceptor
implements NebulaRepositoryInterceptorStrategy {
    private static final Logger log = LoggerFactory.getLogger(DefaultMybatisBaseFieldEnhanceInterceptor.class);
    private static final String CREATE_TIME = "create_time";
    private static final String CREATE_NAME = "create_name";
    private static final String CREATE_ACCOUNT = "create_account";
    private static final String MODIFY_TIME = "modify_time";
    private static final String MODIFY_NAME = "modify_name";
    private static final String MODIFY_ACCOUNT = "modify_account";
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private JpaProperties jpaProperties;

    public String intercept(SqlCommandType sqlCommandType, String sql, Connection currentConnection) {
        if (sqlCommandType != SqlCommandType.INSERT && sqlCommandType != SqlCommandType.UPDATE) {
            return sql;
        }
        try {
            switch (sqlCommandType) {
                case INSERT: {
                    return this.handleInsertSql(sql);
                }
                case UPDATE: {
                    return this.handleUpdateSql(sql);
                }
            }
            return sql;
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            throw new IllegalArgumentException(e);
        }
    }

    private String handleUpdateSql(String sql) throws SQLSyntaxErrorException, NoSuchFieldException, IllegalAccessException {
        SQLUpdateStatement sqlUpdateStatement = (SQLUpdateStatement)this.parser(sql, "mysql");
        String tableName = sqlUpdateStatement.getTableName().getSimpleName();
        log.debug("\u83b7\u53d6\u7684\u8868\u540d\u4e3a\uff1a{}", (Object)tableName);
        TableInfo tableInfo = TableInfoHelper.getTableInfo((String)tableName);
        if (tableInfo == null || !UuidOpEntity.class.isAssignableFrom(tableInfo.getEntityType())) {
            return sql;
        }
        this.buildUpdateStatement(sqlUpdateStatement);
        String newSql = sqlUpdateStatement.toString();
        return newSql;
    }

    private void buildUpdateStatement(SQLUpdateStatement sqlUpdateStatement) {
        SQLCharExpr sqlCharExpr;
        SQLUpdateSetItem sqlUpdateSetItem;
        String name;
        List items = sqlUpdateStatement.getItems();
        boolean existModifyTime = false;
        boolean existModifyName = false;
        boolean existModifyAccount = false;
        LoginDetails context = this.loginUserService.getLoginUser();
        String account = context != null ? context.getAccount() : "default";
        String string = name = context != null ? context.getUsername() : "default";
        if (StringUtils.isEmpty((String)name)) {
            name = "\u7cfb\u7edf\u5b9a\u65f6\u4efb\u52a1";
        }
        for (SQLUpdateSetItem item : items) {
            SQLCharExpr sqlCharExpr2;
            SQLExpr value;
            if (item.columnMatch(MODIFY_TIME)) {
                value = item.getValue();
                if (value instanceof SQLNullExpr) {
                    String now = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime());
                    SQLCharExpr sqlCharExpr3 = new SQLCharExpr(now);
                    item.setValue((SQLExpr)sqlCharExpr3);
                }
                existModifyTime = true;
                continue;
            }
            if (item.columnMatch(MODIFY_NAME)) {
                value = item.getValue();
                if (value instanceof SQLNullExpr) {
                    sqlCharExpr2 = new SQLCharExpr(name);
                    item.setValue((SQLExpr)sqlCharExpr2);
                }
                existModifyName = true;
                continue;
            }
            if (!item.columnMatch(MODIFY_ACCOUNT)) continue;
            value = item.getValue();
            if (value instanceof SQLNullExpr) {
                sqlCharExpr2 = new SQLCharExpr(account);
                item.setValue((SQLExpr)sqlCharExpr2);
            }
            existModifyAccount = true;
        }
        if (!existModifyTime) {
            sqlUpdateSetItem = new SQLUpdateSetItem();
            sqlUpdateSetItem.setColumn((SQLExpr)new SQLIdentifierExpr(MODIFY_TIME));
            SQLCharExpr sqlExpr = null;
            String now = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime());
            if (this.jpaProperties.getDatabase() == Database.ORACLE) {
                ArrayList<SQLCharExpr> params = new ArrayList<SQLCharExpr>();
                params.add(new SQLCharExpr(now));
                params.add(new SQLCharExpr("yyyy-MM-dd HH24:mi:ss"));
                SQLMethodInvokeExpr methodInvokeExpr = new SQLMethodInvokeExpr("to_date", null, params);
                sqlUpdateSetItem.setValue((SQLExpr)methodInvokeExpr);
            } else {
                sqlExpr = new SQLCharExpr(now);
                sqlUpdateSetItem.setValue((SQLExpr)sqlExpr);
            }
            sqlUpdateStatement.addItem(sqlUpdateSetItem);
        }
        if (!existModifyName) {
            sqlUpdateSetItem = new SQLUpdateSetItem();
            sqlUpdateSetItem.setColumn((SQLExpr)new SQLIdentifierExpr(MODIFY_NAME));
            sqlCharExpr = new SQLCharExpr(name);
            sqlUpdateSetItem.setValue((SQLExpr)sqlCharExpr);
            sqlUpdateStatement.addItem(sqlUpdateSetItem);
        }
        if (!existModifyAccount) {
            sqlUpdateSetItem = new SQLUpdateSetItem();
            sqlUpdateSetItem.setColumn((SQLExpr)new SQLIdentifierExpr(MODIFY_ACCOUNT));
            sqlCharExpr = new SQLCharExpr(account);
            sqlUpdateSetItem.setValue((SQLExpr)sqlCharExpr);
            sqlUpdateStatement.addItem(sqlUpdateSetItem);
        }
    }

    private String handleInsertSql(String sql) throws SQLSyntaxErrorException, NoSuchFieldException, IllegalAccessException {
        SQLInsertStatement sqlInsertStatement = (SQLInsertStatement)this.parser(sql, "mysql");
        String tableName = sqlInsertStatement.getTableName().getSimpleName();
        log.debug("\u83b7\u53d6\u7684\u8868\u540d\u4e3a\uff1a{}", (Object)tableName);
        TableInfo tableInfo = TableInfoHelper.getTableInfo((String)tableName);
        if (tableInfo == null || !UuidOpEntity.class.isAssignableFrom(tableInfo.getEntityType())) {
            return sql;
        }
        SQLSelect query = sqlInsertStatement.getQuery();
        if (Objects.nonNull(query)) {
            return sql;
        }
        List columns = sqlInsertStatement.getColumns();
        if (CollectionUtils.isEmpty((Collection)columns)) {
            return sql;
        }
        this.buildInsertStatement(sqlInsertStatement, columns);
        String newSql = sqlInsertStatement.toString();
        return newSql;
    }

    private void buildInsertStatement(SQLInsertStatement sqlInsertStatement, List<SQLExpr> columns) {
        String name;
        boolean existCreateTime = false;
        boolean existCreateName = false;
        boolean existCreateAccount = false;
        boolean existModifyTime = false;
        boolean existModifyAccount = false;
        LoginDetails context = this.loginUserService.getLoginUser();
        String account = context != null ? context.getAccount() : "default";
        String string = name = context != null ? context.getUsername() : "default";
        if (StringUtils.isEmpty((String)name)) {
            name = "\u7cfb\u7edf\u5b9a\u65f6\u4efb\u52a1";
        }
        List valuesList = sqlInsertStatement.getValuesList();
        block14: for (int i = 0; i < columns.size(); ++i) {
            SQLExpr sqlExpr = columns.get(i);
            switch (sqlExpr.toString()) {
                case "create_time": {
                    this.setInsertExistCreateOrModifyTimeValues(valuesList, i);
                    existCreateTime = true;
                    continue block14;
                }
                case "create_name": {
                    this.setInsertExistCreateOrModifyNameValues(valuesList, name, i);
                    existCreateName = true;
                    continue block14;
                }
                case "create_account": {
                    this.setInsertExistCreateOrModifyAccountValues(valuesList, account, i);
                    existCreateAccount = true;
                    continue block14;
                }
                case "modify_time": {
                    this.setInsertExistCreateOrModifyTimeValues(valuesList, i);
                    existModifyTime = true;
                    continue block14;
                }
                case "modify_account": {
                    this.setInsertExistCreateOrModifyAccountValues(valuesList, account, i);
                    existModifyAccount = true;
                }
            }
        }
        this.setInsertCreateOrModifyTimeValues(sqlInsertStatement, valuesList, existCreateTime, CREATE_TIME);
        this.setInsertCreateOrModifyNameValues(sqlInsertStatement, valuesList, existCreateName, context, CREATE_NAME);
        this.setInsertCreateOrModifyAccountValues(sqlInsertStatement, valuesList, existCreateAccount, context, CREATE_ACCOUNT);
        this.setInsertCreateOrModifyTimeValues(sqlInsertStatement, valuesList, existModifyTime, MODIFY_TIME);
        this.setInsertCreateOrModifyAccountValues(sqlInsertStatement, valuesList, existModifyAccount, context, MODIFY_ACCOUNT);
    }

    private void setInsertCreateOrModifyAccountValues(SQLInsertStatement sqlInsertStatement, List<SQLInsertStatement.ValuesClause> valuesList, boolean existCreateAccount, LoginDetails details, String createAccount) {
        if (existCreateAccount) {
            return;
        }
        sqlInsertStatement.addColumn((SQLExpr)new SQLIdentifierExpr(createAccount));
        for (SQLInsertStatement.ValuesClause valuesClause : valuesList) {
            List values = valuesClause.getValues();
            SQLCharExpr sqlCharExpr = new SQLCharExpr(details.getAccount());
            values.add(sqlCharExpr);
        }
    }

    private void setInsertCreateOrModifyNameValues(SQLInsertStatement sqlInsertStatement, List<SQLInsertStatement.ValuesClause> valuesList, boolean existCreateName, LoginDetails details, String createName) {
        if (existCreateName) {
            return;
        }
        sqlInsertStatement.addColumn((SQLExpr)new SQLIdentifierExpr(createName));
        for (SQLInsertStatement.ValuesClause valuesClause : valuesList) {
            List values = valuesClause.getValues();
            SQLCharExpr sqlCharExpr = new SQLCharExpr(details.getUsername());
            values.add(sqlCharExpr);
        }
    }

    private void setInsertExistCreateOrModifyAccountValues(List<SQLInsertStatement.ValuesClause> valuesList, String account, int i) {
        for (SQLInsertStatement.ValuesClause valuesClause : valuesList) {
            List values = valuesClause.getValues();
            if (!(values.get(i) instanceof SQLNullExpr)) {
                return;
            }
            SQLCharExpr sqlCharExpr = new SQLCharExpr(account);
            values.set(i, sqlCharExpr);
        }
    }

    private void setInsertCreateOrModifyTimeValues(SQLInsertStatement sqlInsertStatement, List<SQLInsertStatement.ValuesClause> valuesList, boolean existCreateTime, String createTime) {
        if (existCreateTime) {
            return;
        }
        sqlInsertStatement.addColumn((SQLExpr)new SQLIdentifierExpr(createTime));
        for (SQLInsertStatement.ValuesClause valuesClause : valuesList) {
            String now;
            List values = valuesClause.getValues();
            SQLCharExpr sqlExpr = null;
            if (this.jpaProperties.getDatabase() == Database.ORACLE) {
                now = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime());
                SQLCharExpr nowExpr = new SQLCharExpr(now);
                SQLCharExpr formatExpr = new SQLCharExpr("yyyy-MM-dd HH24:mi:ss");
                sqlExpr = new OracleDatetimeExpr((SQLExpr)nowExpr, (SQLExpr)formatExpr);
            } else {
                now = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime());
                if (this.jpaProperties.getDatabase() == Database.ORACLE) {
                    ArrayList<SQLCharExpr> params = new ArrayList<SQLCharExpr>();
                    params.add(new SQLCharExpr(now));
                    params.add(new SQLCharExpr("yyyy-MM-dd HH24:mi:ss"));
                    sqlExpr = new SQLMethodInvokeExpr("to_date", null, params);
                } else {
                    sqlExpr = new SQLCharExpr(now);
                }
            }
            values.add(sqlExpr);
        }
    }

    private void setInsertExistCreateOrModifyNameValues(List<SQLInsertStatement.ValuesClause> valuesList, String account, int i) {
        for (SQLInsertStatement.ValuesClause valuesClause : valuesList) {
            List values = valuesClause.getValues();
            if (!(values.get(i) instanceof SQLNullExpr)) {
                return;
            }
            SQLCharExpr sqlCharExpr = new SQLCharExpr(account);
            values.set(i, sqlCharExpr);
        }
    }

    private void setInsertExistCreateOrModifyTimeValues(List<SQLInsertStatement.ValuesClause> valuesList, int i) {
        for (SQLInsertStatement.ValuesClause valuesClause : valuesList) {
            String now;
            List values = valuesClause.getValues();
            if (!(values.get(i) instanceof SQLNullExpr)) {
                return;
            }
            SQLCharExpr sqlExpr = null;
            if (this.jpaProperties.getDatabase() == Database.ORACLE) {
                now = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime());
                SQLCharExpr nowExpr = new SQLCharExpr(now);
                SQLCharExpr formatExpr = new SQLCharExpr("yyyy-MM-dd HH24:mi:ss");
                sqlExpr = new OracleDatetimeExpr((SQLExpr)nowExpr, (SQLExpr)formatExpr);
            } else {
                now = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime());
                sqlExpr = new SQLCharExpr(now);
            }
            values.set(i, sqlExpr);
        }
    }

    public SQLStatement parser(String sql, String dbType) throws SQLSyntaxErrorException {
        List list = SQLUtils.parseStatements((String)sql, (String)dbType);
        if (list.size() > 1) {
            throw new SQLSyntaxErrorException("MultiQueries is not supported,use single query instead ");
        }
        return (SQLStatement)list.get(0);
    }

    public int sort() {
        return 2;
    }
}

