/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.AbstractLoginUser;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import com.bizunited.nebula.security.sdk.vo.LoginDetails;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class DefaultLoginUserServiceImpl
implements LoginUserService {
    @Autowired
    private SimpleSecurityProperties simpleSecurityProperties;

    @Override
    public Authentication getAuthentication() {
        if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null) {
            return SecurityContextHolder.getContext().getAuthentication();
        }
        return null;
    }

    @Override
    public String getLoginAccountName() {
        if (this.getAuthentication() == null) {
            return null;
        }
        return this.getAuthentication().getName();
    }

    @Override
    public LoginDetails getLoginUser() {
        if (this.getAuthentication() == null) {
            return null;
        }
        Object details = this.getAuthentication().getDetails();
        if (details == null) {
            return null;
        }
        if (details instanceof LoginDetails) {
            return (LoginDetails)details;
        }
        return null;
    }

    @Override
    public AbstractLoginUser getAbstractLoginUser() {
        LoginDetails loginUser = this.getLoginUser();
        if (loginUser instanceof AbstractLoginUser) {
            return (AbstractLoginUser)loginUser;
        }
        return null;
    }

    @Override
    public JSONObject getLoginUserJson() {
        LoginDetails loginUser = this.getLoginUser();
        return JsonUtils.toJSONObject((Object)loginUser);
    }

    @Override
    public <T extends LoginDetails> T getLoginDetails(Class<T> targetClass) {
        if (this.getAuthentication() == null) {
            return null;
        }
        Object details = this.getAuthentication().getDetails();
        LoginDetails targetObject = null;
        if (details instanceof LoginDetails) {
            targetObject = (LoginDetails)details;
        }
        return (T)targetObject;
    }

    @Override
    public Authentication refreshLogin(LoginUserDetails loginUserDetails) {
        Validate.notNull((Object)loginUserDetails, (String)"\u9519\u8bef\u7684\u7528\u6237\u8eab\u4efd\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        String tenantCode = loginUserDetails.getTenantCode();
        Validate.notBlank((CharSequence)tenantCode, (String)"\u7ec4\u88c5\u7528\u6237\u8eab\u4efd\u4fe1\u606f\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684\u4e8c\u7ea7\u79df\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String account = loginUserDetails.getAccount();
        Validate.notBlank((CharSequence)account, (String)"\u7ec4\u88c5\u7528\u6237\u8eab\u4efd\u4fe1\u606f\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684\u8d26\u53f7\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        List<String> roles = loginUserDetails.getRoles();
        Validate.isTrue((!CollectionUtils.isEmpty(roles) ? 1 : 0) != 0, (String)"\u7ec4\u88c5\u7528\u6237\u8eab\u4efd\u4fe1\u606f\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684\u7528\u6237\u89d2\u8272\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        ArrayList grantedAuthorities = Lists.newArrayList();
        loginUserDetails.getRoles().forEach(r -> grantedAuthorities.add(new SimpleGrantedAuthority(r)));
        return this.refreshLogin(loginUserDetails, grantedAuthorities);
    }

    @Override
    public Authentication refreshLogin(AbstractLoginUser loginUser, List<SimpleGrantedAuthority> grantedAuthorities) {
        Integer type = loginUser.getType();
        if (type == null) {
            type = this.simpleSecurityProperties.getDefaultLoginType();
            loginUser.setType(type);
        }
        Validate.notNull((Object)type, (String)"\u7ec4\u88c5\u7528\u6237\u8eab\u4efd\u4fe1\u606f\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684\u767b\u5f55\u65b9\u5f0f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String password = StringUtils.isBlank((CharSequence)loginUser.getPassword()) ? "123456" : loginUser.getPassword();
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)loginUser.getAccount(), (Object)password, grantedAuthorities);
        authentication.setDetails((Object)loginUser);
        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        return this.getAuthentication();
    }
}

