/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.local.strategy.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.strategy.ContextTransmitStrategy;
import com.bizunited.nebula.security.sdk.vo.LoginDetails;
import feign.RequestTemplate;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Service;

@Service
public class SecurityContextTransmitStrategyImpl
implements ContextTransmitStrategy {
    private static final Logger log = LoggerFactory.getLogger(SecurityContextTransmitStrategyImpl.class);
    @Autowired
    private LoginUserService loginUserService;

    @Override
    public void transmit(RequestTemplate requestTemplate) {
        if (this.existed(requestTemplate)) {
            log.info("<\u975eWEB\u5bb9\u5668\u8bf7\u6c42\u4e4b\u52a8\u6001\u4efb\u52a1>\u62e6\u622a\u5668\u68c0\u67e5\u5230\u5df2\u7ecf\u5b58\u5728\u4f1a\u8bdd\u4fe1\u606f!!");
            return;
        }
        Authentication authentication = this.loginUserService.getAuthentication();
        if (authentication == null) {
            log.warn("<\u975eWEB\u5bb9\u5668\u8bf7\u6c42\u4e4b\u52a8\u6001\u4efb\u52a1>\u672a\u53d6\u5f97\u9274\u6743\u5173\u952e\u5bf9\u8c61\uff0c\u8bf7\u5148\u767b\u5f55!!");
            return;
        }
        LoginDetails details = (LoginDetails)authentication.getDetails();
        if (details == null) {
            log.warn("<\u975eWEB\u5bb9\u5668\u8bf7\u6c42\u4e4b\u52a8\u6001\u4efb\u52a1>\u672a\u53d6\u5f97\u9274\u6743\u5173\u952e\u4fe1\u606f!!\u7528\u6237\uff1anull ");
            return;
        }
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{details.getTenantCode(), details.getAccount()})) {
            log.warn("<\u975eWEB\u5bb9\u5668\u8bf7\u6c42\u4e4b\u52a8\u6001\u4efb\u52a1>\u672a\u53d6\u5f97\u9274\u6743\u5173\u952e\u4fe1\u606f!!\u79df\u6237\u7f16\u7801\uff1a{}\uff0c\u8d26\u53f7\uff1a{}\uff0c", (Object)details.getTenantCode(), (Object)details.getAccount());
            return;
        }
        Collection grantedAuthority = authentication.getAuthorities();
        if (CollectionUtils.isEmpty((Collection)grantedAuthority)) {
            log.warn("<\u975eWEB\u5bb9\u5668\u8bf7\u6c42\u4e4b\u52a8\u6001\u4efb\u52a1>\u672a\u53d6\u5f97\u9274\u6743\u5173\u952e\u4fe1\u606f!!\u79df\u6237\u7f16\u7801\uff1a{}\uff0c\u8d26\u53f7\uff1a{}\uff0c\u89d2\u8272: null", (Object)details.getTenantCode(), (Object)details.getAccount());
            return;
        }
        String[] roles = (String[])grantedAuthority.stream().map(GrantedAuthority::getAuthority).toArray(String[]::new);
        JSONObject authorizationVo = new JSONObject();
        authorizationVo.put("tenantCode", (Object)details.getTenantCode());
        authorizationVo.put("account", (Object)details.getAccount());
        authorizationVo.put("roles", Arrays.asList(roles));
        requestTemplate.header("NON_WEB_REQUEST", new String[]{authorizationVo.toJSONString()});
    }

    @Override
    public int order() {
        return 2;
    }
}

