/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.local.config;

import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.KeyExpirationEventMessageListener;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.stereotype.Component;

@Component
public class RegistrarServerMsgHandler
extends KeyExpirationEventMessageListener
implements ApplicationRunner {
    @Value(value="${spring.application.name:}")
    private String systemName;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    public RegistrarServerMsgHandler(RedisMessageListenerContainer listenerContainer) {
        super(listenerContainer);
    }

    public void onMessage(Message message, byte[] pattern) {
        String key = message.toString();
        if (key.equals("springboot-system-".concat(this.systemName))) {
            this.redisTemplate.opsForValue().set((Object)key, (Object)this.systemName, 6L, TimeUnit.HOURS);
        }
    }

    public void run(ApplicationArguments args) throws Exception {
        String key = "springboot-system-" + this.systemName;
        if (this.redisTemplate.hasKey((Object)key).booleanValue()) {
            this.redisTemplate.expire((Object)key, 6L, TimeUnit.HOURS);
        }
        this.redisTemplate.opsForValue().set((Object)key, (Object)this.systemName, 6L, TimeUnit.HOURS);
    }
}

