/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.local.config;

import com.biz.crm.business.common.local.config.SignProperties;
import com.biz.crm.business.common.sdk.service.SignService;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableAutoConfiguration
@EnableConfigurationProperties(value={SignProperties.class})
public class SignConfiguration {
    @Autowired
    private SignProperties appProperties;

    @PostConstruct
    private void init() {
        Map<String, SignProperties.AppInfo> apps = this.appProperties.getApps();
        apps.forEach((k, v) -> {
            Validate.notBlank((CharSequence)v.getAppKey(), (String)"appKey not be blank", (Object[])new Object[0]);
            v.setAppId((String)k);
        });
    }

    @Bean
    public SignService getSignService() {
        return new SignService();
    }
}

