/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.local.embedded.impl;

import com.biz.crm.business.common.local.embedded.MdmServletWebServerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.servlet.server.AbstractServletWebServerFactory;
import org.springframework.stereotype.Service;

@Service
public class MdmTomcatWebServerFactoryCustomizer
implements MdmServletWebServerFactory<TomcatServletWebServerFactory> {
    private static final int DEFAULT_MAX_PARAMETER_COUNT = 10000;
    @Value(value="${server.tomcat.maxParameterCount:10000}")
    private int maxParameterCount = 10000;

    @Override
    public boolean filter(AbstractServletWebServerFactory factory) {
        boolean b = factory instanceof TomcatServletWebServerFactory;
        return b;
    }

    @Override
    public void customize(TomcatServletWebServerFactory factory) {
        PropertyMapper propertyMapper = PropertyMapper.get();
        propertyMapper.from((Object)this.maxParameterCount).when(maxParameterCount -> maxParameterCount != 10000).to(maxParameterCount -> factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{connector -> connector.setMaxParameterCount(maxParameterCount.intValue())}));
    }
}

