/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.local.interceptor;

import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.springframework.beans.factory.annotation.Autowired;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class DefaultMybatisBaseFieldInterceptor
implements Interceptor {
    @Autowired
    private LoginUserService loginUserService;

    public Object intercept(Invocation invocation) throws Throwable {
        Map map;
        Object parameter = invocation.getArgs()[1];
        MappedStatement statement = (MappedStatement)invocation.getArgs()[0];
        if (parameter instanceof MapperMethod.ParamMap && (map = (Map)parameter).containsKey("et") && Objects.nonNull(map.get("et"))) {
            parameter = ((Map)parameter).get("et");
        }
        if (parameter instanceof UuidOpEntity) {
            UuidOpEntity entity = (UuidOpEntity)parameter;
            AbstractCrmUserIdentity context = this.loginUserService.getAbstractLoginUser();
            String account = context != null ? context.getAccount() : "admin";
            String username = context != null ? context.getRealName() : "\u7cfb\u7edf\u7ba1\u7406\u5458\u6216\u7cfb\u7edf\u5b9a\u65f6\u4efb\u52a1";
            switch (statement.getSqlCommandType()) {
                case INSERT: {
                    entity.setCreateTime(new Date());
                    entity.setCreateName(username);
                    entity.setCreateAccount(account);
                    entity.setModifyTime(new Date());
                    entity.setModifyName(username);
                    entity.setModifyAccount(account);
                    break;
                }
                case UPDATE: {
                    entity.setModifyTime(new Date());
                    entity.setModifyName(username);
                    entity.setModifyAccount(account);
                    break;
                }
            }
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }
}

