/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.sdk.sensitive;

import com.biz.crm.business.common.sdk.sensitive.Sensitive;
import com.biz.crm.business.common.sdk.sensitive.SensitiveStrategy;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class SensitiveJsonSerializer
extends JsonSerializer<String>
implements ContextualSerializer {
    private SensitiveStrategy strategy;

    public void serialize(String value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (StringUtils.isBlank((CharSequence)value) || this.strategy == null) {
            gen.writeString(value);
            return;
        }
        gen.writeString(this.strategy.desensitizer().apply(value));
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        Sensitive annotation = (Sensitive)property.getAnnotation(Sensitive.class);
        if (Objects.nonNull(annotation) && Objects.equals(String.class, property.getType().getRawClass())) {
            this.strategy = annotation.strategy();
            return this;
        }
        return prov.findValueSerializer(property.getType(), property);
    }
}

