/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.sdk.service;

import com.biz.crm.business.common.local.config.SignProperties;
import com.biz.crm.business.common.sdk.utils.Md5Utils;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;

public class SignService {
    @Autowired
    private SignProperties signProperties;

    public String getCurrentAppId() {
        return this.signProperties.getAppId();
    }

    public String sign(String content) {
        String appId = this.signProperties.getAppId();
        Validate.notBlank((CharSequence)appId, (String)"\u5f53\u524d\u7cfb\u7edf\u672a\u914d\u7f6eappId", (Object[])new Object[0]);
        return this.sign(appId, content);
    }

    public String sign(String appId, String content) {
        Validate.notBlank((CharSequence)appId, (String)"appId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)content, (String)"\u7b7e\u540d\u6570\u636e\u5185\u5bb9\u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
        SignProperties.AppInfo app = this.signProperties.getApp(appId);
        Validate.notNull((Object)app, (String)"\u672a\u627e\u5230\u914d\u7f6e\u7684app:%s", (Object[])new Object[]{appId});
        String signContent = StringUtils.join((Object[])new String[]{appId, content, app.getAppKey()});
        return Md5Utils.encode(signContent, Md5Utils.EncodeType.HEX);
    }

    public void verify(String appId, String content, String sign) {
        Validate.notBlank((CharSequence)sign, (String)"\u9a8c\u8bc1\u7684\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String contentSign = this.sign(appId, content);
        Validate.isTrue((boolean)contentSign.equals(sign), (String)"\u7b7e\u540d\u4e0d\u6b63\u786e", (Object[])new Object[0]);
    }

    public String sign(Map<String, String> params) {
        String appId = this.signProperties.getAppId();
        Validate.notBlank((CharSequence)appId, (String)"\u5f53\u524d\u7cfb\u7edf\u672a\u914d\u7f6eappId", (Object[])new Object[0]);
        return this.sign(appId, params);
    }

    public String sign(String appId, Map<String, String> params) {
        Validate.notBlank((CharSequence)appId, (String)"appId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull(params, (String)"\u6570\u636e\u5185\u5bb9\u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
        SignProperties.AppInfo app = this.signProperties.getApp(appId);
        Validate.notNull((Object)app, (String)"\u672a\u627e\u5230\u914d\u7f6e\u7684app:%s", (Object[])new Object[]{appId});
        TreeMap<String, String> treeParams = new TreeMap<String, String>(params);
        String paramsContent = this.getParamsContent(treeParams);
        return this.sign(appId, paramsContent);
    }

    public void verify(String appId, Map<String, String> params, String sign) {
        Validate.notNull(params, (String)"\u6570\u636e\u5185\u5bb9\u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
        String contentSign = this.sign(appId, params);
        Validate.isTrue((boolean)contentSign.equals(sign), (String)"\u7b7e\u540d\u4e0d\u6b63\u786e", (Object[])new Object[0]);
    }

    private String getParamsContent(TreeMap<String, String> treeParams) {
        ArrayList paramList = new ArrayList();
        treeParams.forEach((k, v) -> {
            if (StringUtils.isNotBlank((CharSequence)v) && !"sign".equals(k)) {
                paramList.add(StringUtils.join((Object[])new String[]{k, "=", v}));
            }
        });
        return StringUtils.join(paramList, (String)"&");
    }
}

