/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.sdk.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

public class DateTimeValidateUtil {
    public static final String TIME_STR_120000 = "12:00:00";
    public static final String TIME_STR_000000 = "00:00:00";
    public static final String TIME_STR_235959 = "23:59:59";
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter YYYY_MM_DD = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter HH_MM_SS = DateTimeFormatter.ofPattern("HH:mm:ss");
    public static final DateTimeFormatter YYYY_MM = DateTimeFormatter.ofPattern("yyyy-MM");
    public static final DateTimeFormatter YYYY = DateTimeFormatter.ofPattern("yyyy");

    public static Boolean validateDateTime(String dateTime) {
        Boolean result;
        try {
            LocalDateTime.parse(dateTime, YYYY_MM_DD_HH_MM_SS);
            result = Boolean.TRUE;
        }
        catch (Exception e) {
            result = Boolean.FALSE;
        }
        return result;
    }

    public static Boolean validateDate(String date) {
        Boolean result;
        try {
            LocalDate.parse(date, YYYY_MM_DD);
            result = Boolean.TRUE;
        }
        catch (Exception e) {
            result = Boolean.FALSE;
        }
        return result;
    }

    public static Boolean validateTime(String time) {
        Boolean result;
        try {
            LocalTime.parse(time, HH_MM_SS);
            result = Boolean.TRUE;
        }
        catch (Exception e) {
            result = Boolean.FALSE;
        }
        return result;
    }

    private DateTimeValidateUtil() {
    }
}

