/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.sdk.utils;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Base64Utils;

public class Md5Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Md5Utils.class);

    private Md5Utils() {
        throw new IllegalStateException("\u9759\u6001\u7c7b\u4e0d\u80fd\u8fdb\u884c\u521d\u59cb\u5316");
    }

    public static String encode(String content, EncodeType encodeType) {
        Validate.notNull((Object)content, (String)"\u52a0\u5bc6\u6587\u672c\u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
        String resultString = null;
        encodeType = (EncodeType)((Object)ObjectUtils.defaultIfNull((Object)((Object)encodeType), (Object)((Object)EncodeType.HEX)));
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytes = md.digest(content.getBytes(StandardCharsets.UTF_8));
            switch (encodeType) {
                case HEX: {
                    resultString = Hex.encodeHexString((byte[])bytes);
                    break;
                }
                case BASE64: {
                    resultString = Base64Utils.encodeToString((byte[])bytes);
                    break;
                }
            }
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        return resultString;
    }

    public static enum EncodeType {
        HEX,
        BASE64;

    }
}

