/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.sdk.utils;

import com.bizunited.nebula.security.sdk.login.UserIdentity;
import org.apache.commons.lang3.Validate;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public final class SecurityUtils {
    public static final String ANONYMOUS_USER = "anonymousUser";

    private SecurityUtils() {
        throw new IllegalStateException("\u9759\u6001\u5de5\u5177\u7c7b\u4e0d\u5141\u8bb8\u5b9e\u4f8b\u5316");
    }

    public static Authentication getAuthentication() {
        if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null) {
            return SecurityContextHolder.getContext().getAuthentication();
        }
        return null;
    }

    public static String getUserAccount() {
        Validate.notNull((Object)SecurityUtils.getAuthentication(), (String)"\u5f53\u524d\u7cfb\u7edf\u672a\u767b\u5f55\u7528\u6237\uff01", (Object[])new Object[0]);
        Object details = SecurityUtils.getAuthentication().getDetails();
        Validate.notNull((Object)details, (String)"\u5f53\u524d\u7cfb\u7edf\u672a\u767b\u5f55\u7528\u6237\uff01", (Object[])new Object[0]);
        if (details instanceof UserIdentity) {
            String account = ((UserIdentity)details).getAccount();
            Validate.notBlank((CharSequence)account, (String)"\u5f53\u524d\u7cfb\u7edf\u672a\u767b\u5f55\u7528\u6237\uff01", (Object[])new Object[0]);
            Validate.isTrue((!ANONYMOUS_USER.equals(account) ? 1 : 0) != 0, (String)"\u5f53\u524d\u7cfb\u7edf\u672a\u767b\u5f55\u7528\u6237\uff01", (Object[])new Object[0]);
            return account;
        }
        return null;
    }
}

