/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.sdk.utils.wx.open;

import com.biz.crm.business.common.sdk.utils.wx.open.WxOpenHttpExecute;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxOpenHttpExecuteImpl
implements WxOpenHttpExecute {
    private static final Logger LOGGER = LoggerFactory.getLogger(WxOpenHttpExecuteImpl.class);

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R> R doExecute(Supplier<HttpRequestBase> request, Function<CloseableHttpResponse, R> response) {
        HttpRequestBase httpRequestBase = request.get();
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(12000).setConnectTimeout(12000).setSocketTimeout(12000).build();
        httpRequestBase.setConfig(requestConfig);
        try (CloseableHttpClient build = HttpClientBuilder.create().build();){
            R r;
            block15: {
                CloseableHttpResponse httpResponse = build.execute((HttpUriRequest)httpRequestBase);
                try {
                    if (!Objects.equals(httpResponse.getStatusLine().getStatusCode(), 200)) {
                        throw new HttpResponseException(httpResponse.getStatusLine().getStatusCode(), "\u8c03\u7528\u5931\u8d25\uff0c\u8fd4\u56de\u72b6\u6001\u7801: " + httpResponse.getStatusLine().getStatusCode());
                    }
                    r = response.apply(httpResponse);
                    if (httpResponse == null) break block15;
                }
                catch (Throwable throwable) {
                    if (httpResponse != null) {
                        try {
                            httpResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                httpResponse.close();
            }
            return r;
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new UncheckedIOException(e);
        }
    }
}

