/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.sdk.utils.wx.open;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.utils.wx.open.WxOpenHttpExecute;
import com.biz.crm.business.common.sdk.utils.wx.open.WxOpenInfo;
import com.biz.crm.business.common.sdk.utils.wx.open.WxOpenServiceProvision;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxOpenQrcodeProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(WxOpenQrcodeProcessor.class);
    private final WxOpenHttpExecute wxOpenHttpExecutor;
    private final WxOpenServiceProvision wxOpenServiceProvision;

    WxOpenQrcodeProcessor(WxOpenServiceProvision wxOpenServiceProvision, WxOpenHttpExecute wxOpenHttpExecutor) {
        this.wxOpenServiceProvision = wxOpenServiceProvision;
        this.wxOpenHttpExecutor = wxOpenHttpExecutor;
    }

    public byte[] createQrcode(String path) {
        Validate.notBlank((CharSequence)path, (String)"\u83b7\u53d6\u7b2c\u4e09\u65b9\u5c0f\u7a0b\u5e8f\u4e8c\u7ef4\u7801\u65f6,\u5c0f\u7a0b\u5e8f\u8df3\u8f6c\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return this.createQrcode(path, 430);
    }

    public byte[] createQrcode(String path, Integer width) {
        Validate.notBlank((CharSequence)path, (String)"\u83b7\u53d6\u7b2c\u4e09\u65b9\u5c0f\u7a0b\u5e8f\u4e8c\u7ef4\u7801\u56fe\u7247\u65f6\uff0c\u8df3\u8f6c\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01\uff01", (Object[])new Object[0]);
        Validate.isTrue((path.length() <= 128 ? 1 : 0) != 0, (String)"\u5c0f\u7a0b\u5e8f\u9875\u9762\u8def\u5f84: %s , \u8d85\u51fa\u6700\u5927\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 128 \u5b57\u8282\uff01\uff01\uff01", (Object[])new Object[]{path});
        Validate.notNull((Object)width, (String)"\u83b7\u53d6\u7b2c\u4e09\u65b9\u5c0f\u7a0b\u5e8f\u4e8c\u7ef4\u7801\u56fe\u7247\u65f6\uff0c\u56fe\u7247\u5927\u5c0f\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01\uff01", (Object[])new Object[0]);
        Validate.isTrue((width >= 280 && width <= 1280 ? 1 : 0) != 0, (String)"\u4e8c\u7ef4\u7801\u7684\u5bbd\u5ea6 %s \u8d85\u51fa\u9650\u5236\uff1a\u6700\u5c0f 280px\uff0c\u6700\u5927 1280px\uff01\uff01\uff01", (long)width.intValue());
        HashMap<Object, Object> dataMap = new HashMap<Object, Object>();
        dataMap.put("path", path);
        dataMap.put("width", width);
        return this.createQrcodeOnExecute("https://api.weixin.qq.com/cgi-bin/wxaapp/createwxaqrcode?access_token=%s", dataMap);
    }

    public byte[] createWxaCodeUnlimitBytes(String scene, String page, Integer width) {
        return this.createWxaCodeUnlimitBytes(scene, page, width, false, 0, 0, 0, false);
    }

    public byte[] createWxaCodeUnlimitBytes(String scene, String page, Integer width, boolean autoColor, Integer r, Integer g, Integer b, boolean isHyaline) {
        Validate.isTrue((StringUtils.isBlank((CharSequence)page) || !page.startsWith("/") ? 1 : 0) != 0, (String)"\u8def\u5f84:\u3010%s\u3011\u6839\u8def\u5f84\u524d\u4e0d\u8981\u586b\u52a0 /", (Object[])new Object[]{page});
        Validate.notBlank((CharSequence)scene, (String)"\u8bf7\u6c42 scene \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        HashMap<Object, Object> dataMap = new HashMap<Object, Object>();
        dataMap.put("scene", scene);
        dataMap.put("page", page);
        dataMap.put("width", width);
        dataMap.put("auto_color", autoColor);
        dataMap.put("is_hyaline", isHyaline);
        if (autoColor && Objects.nonNull(r) && Objects.nonNull(g) && Objects.nonNull(b)) {
            dataMap.put("line_color", ImmutableMap.of((Object)"r", (Object)r, (Object)"g", (Object)g, (Object)"b", (Object)b));
        }
        return this.createQrcodeOnExecute("https://api.weixin.qq.com/wxa/getwxacodeunlimit?access_token=%s", dataMap);
    }

    public byte[] createWxaCodeBytes(String page, Integer width) {
        return this.createWxaCodeBytes(page, width, false, 0, 0, 0, false);
    }

    public byte[] createWxaCodeBytes(String page, Integer width, boolean autoColor, Integer r, Integer g, Integer b, boolean isHyaline) {
        Validate.isTrue((StringUtils.isBlank((CharSequence)page) || !page.startsWith("/") ? 1 : 0) != 0, (String)"\u8def\u5f84:\u3010%s\u3011\u6839\u8def\u5f84\u524d\u4e0d\u8981\u586b\u52a0 /", (Object[])new Object[]{page});
        HashMap<Object, Object> dataMap = new HashMap<Object, Object>();
        dataMap.put("path", page);
        dataMap.put("width", width);
        dataMap.put("auto_color", autoColor);
        dataMap.put("is_hyaline", isHyaline);
        if (autoColor && Objects.nonNull(r) && Objects.nonNull(g) && Objects.nonNull(b)) {
            dataMap.put("line_color", ImmutableMap.of((Object)"r", (Object)r, (Object)"g", (Object)g, (Object)"b", (Object)b));
        }
        return this.createQrcodeOnExecute("https://api.weixin.qq.com/wxa/getwxacode?access_token=%s", dataMap);
    }

    public byte[] createQrcodeOnExecute(String url, HashMap<Object, Object> dataMap) {
        Supplier<HttpRequestBase> request = () -> {
            StringEntity stringEntity;
            WxOpenInfo wxOpenInfo = this.wxOpenServiceProvision.getWxOpenInfo();
            Validate.notNull((Object)wxOpenInfo, (String)"\u672a\u627e\u5230\u7b2c\u4e09\u65b9\u5c0f\u7a0b\u5e8f\u914d\u7f6e\u4fe1\u606f\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)wxOpenInfo.getAuthorizerAccessToken(), (String)"\u8c03\u7528\u7b2c\u4e09\u65b9\u5c0f\u7a0b\u5e8f\u6388\u6743token\u4e3a\u8fd4\u56de\u7684\u6388\u6743\u5c0f\u7a0b\u5e8fAccessToken\u4fe1\u606f\u7a7a", (Object[])new Object[0]);
            String urlToken = String.format(url, wxOpenInfo.getAuthorizerAccessToken());
            HttpPost httpPost = new HttpPost(urlToken);
            httpPost.setHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
            try {
                stringEntity = new StringEntity(JSONObject.toJSONString((Object)dataMap));
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new UncheckedIOException(e);
            }
            httpPost.setEntity((HttpEntity)stringEntity);
            return httpPost;
        };
        Function<CloseableHttpResponse, byte[]> response = httpResponse -> {
            byte[] byArray;
            block9: {
                InputStream inputStream = httpResponse.getEntity().getContent();
                try {
                    if (StringUtils.equalsIgnoreCase((CharSequence)httpResponse.getEntity().getContentType().getValue(), (CharSequence)ContentType.APPLICATION_JSON.toString())) {
                        String responseStr = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                        Validate.isTrue((StringUtils.isBlank((CharSequence)responseStr) || Objects.equals(JSONObject.parseObject((String)responseStr).get((Object)"errcode"), 0) ? 1 : 0) != 0, (String)"\u83b7\u53d6\u7b2c\u4e09\u65b9\u5c0f\u7a0b\u5e8f\u4e8c\u7ef4\u7801\u56fe\u7247\u5931\u8d25\uff1a\u3010%s\u3011", (Object[])new Object[]{responseStr});
                    }
                    byArray = IOUtils.toByteArray((InputStream)inputStream);
                    if (inputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                        throw new UncheckedIOException(e);
                    }
                }
                inputStream.close();
            }
            return byArray;
        };
        return this.wxOpenHttpExecutor.doExecute(request, response);
    }
}

