/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.sdk.utils.wx.open;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.utils.wx.open.InternalWxOpenInfoProcessor;
import com.biz.crm.business.common.sdk.utils.wx.open.WxOpenHttpExecute;
import com.biz.crm.business.common.sdk.utils.wx.open.WxOpenHttpExecuteImpl;
import com.biz.crm.business.common.sdk.utils.wx.open.WxOpenInfo;
import com.biz.crm.business.common.sdk.utils.wx.open.WxOpenQrcodeProcessor;
import com.biz.crm.business.common.sdk.utils.wx.open.WxOpenServiceProvision;
import com.biz.crm.business.common.sdk.utils.wx.open.WxOpenUserProcessor;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxOpenServiceProvisionImpl
implements WxOpenServiceProvision {
    private static final Logger LOGGER = LoggerFactory.getLogger(WxOpenServiceProvisionImpl.class);
    private final WxOpenHttpExecute wxOpenHttpExecutor = new WxOpenHttpExecuteImpl();
    private final InternalWxOpenInfoProcessor internalWxOpenInfoProcessor = new InternalWxOpenInfoProcessor();
    private final WxOpenUserProcessor wxOpenUserProcessor = new WxOpenUserProcessor(this, this.wxOpenHttpExecutor);
    private final WxOpenQrcodeProcessor wxOpenQrcodeProcessor = new WxOpenQrcodeProcessor(this, this.wxOpenHttpExecutor);
    private RedisMutexService redisMutexService;
    private static final String WX_OPEN_INFO_CACHE_LOCK = "wx:open:info:lock:%s:%s";
    private static final String WX_OPEN_INFO_CACHE = "wx:open:info:cache";

    @Override
    public void enableCache(RedisMutexService redisMutexService) {
        this.redisMutexService = redisMutexService;
    }

    @Override
    public WxOpenInfo getWxOpenInfo() {
        InternalWxOpenInfoProcessor.InternalWxOpenInfoParam param = this.internalWxOpenInfoProcessor.getInternalWxOpenInfoParam();
        Validate.notBlank((CharSequence)param.getTenantCode(), (String)"\u914d\u7f6e\u7684\u7b2c\u4e09\u65b9\u5c0f\u7a0b\u5e8f\u7684\u79df\u6237\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)param.getAppletType(), (String)"\u914d\u7f6e\u7684\u7b2c\u4e09\u65b9\u5c0f\u7a0b\u5e8f\u7684\u5c0f\u7a0b\u5e8f\u7c7b\u578b\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
        if (Objects.isNull(this.redisMutexService)) {
            WxOpenInfo wxOpenInfo = this.getWxOpenParams(param);
            Validate.notNull((Object)wxOpenInfo, (String)"\u8c03\u7528\u7b2c\u4e09\u65b9\u5c0f\u7a0b\u5e8f\u6388\u6743token\u4e3a\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)wxOpenInfo.getAuthorizerAppid(), (String)"\u8c03\u7528\u7b2c\u4e09\u65b9\u5c0f\u7a0b\u5e8f\u6388\u6743token\u4e3a\u8fd4\u56de\u7684APPID\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)wxOpenInfo.getComponentAppid(), (String)"\u8c03\u7528\u7b2c\u4e09\u65b9\u5c0f\u7a0b\u5e8f\u6388\u6743token\u4e3a\u8fd4\u56de\u7684\u7b2c\u4e09\u65b9APPID\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)wxOpenInfo.getComponentAccessToken(), (String)"\u8c03\u7528\u7b2c\u4e09\u65b9\u5c0f\u7a0b\u5e8f\u6388\u6743token\u4e3a\u8fd4\u56de\u7684\u7b2c\u4e09\u65b9AccessToken\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)wxOpenInfo.getEndTime(), (String)"\u8c03\u7528\u7b2c\u4e09\u65b9\u5c0f\u7a0b\u5e8f\u6388\u6743token\u4e3a\u8fd4\u56de\u7684\u7b2c\u4e09\u65b9AccessToken\u8fc7\u671f\u65f6\u95f4\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((wxOpenInfo.getEndTime() > 0 ? 1 : 0) != 0, (String)"\u7b2c\u4e09\u65b9\u5c0f\u7a0b\u5e8f\u6388\u6743token\u4e3a\u8fd4\u56de\u7684AccessToken\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u8bd5\uff01\uff01\uff01", (Object[])new Object[0]);
            return wxOpenInfo;
        }
        String mapKey = StringUtils.join((Object[])new Serializable[]{param.getTenantCode(), "-", param.getAppletType()});
        String cache = this.redisMutexService.getMCode(WX_OPEN_INFO_CACHE, mapKey);
        if (StringUtils.isNotBlank((CharSequence)cache)) {
            return (WxOpenInfo)JSONObject.parseObject((String)cache, WxOpenInfo.class);
        }
        String lockKey = String.format(WX_OPEN_INFO_CACHE_LOCK, param.getTenantCode(), param.getAppletType());
        try {
            boolean locked = this.redisMutexService.tryLock(lockKey, TimeUnit.MILLISECONDS, 15000);
            if (locked) {
                cache = this.redisMutexService.getMCode(WX_OPEN_INFO_CACHE, mapKey);
                if (StringUtils.isNotBlank((CharSequence)cache)) {
                    WxOpenInfo wxOpenInfo = (WxOpenInfo)JSONObject.parseObject((String)cache, WxOpenInfo.class);
                    return wxOpenInfo;
                }
                WxOpenInfo wxOpenInfo = this.getWxOpenParams(param);
                Validate.notNull((Object)wxOpenInfo, (String)"\u8c03\u7528\u7b2c\u4e09\u65b9\u5c0f\u7a0b\u5e8f\u6388\u6743token\u4e3a\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)wxOpenInfo.getComponentAppid(), (String)"\u8c03\u7528\u7b2c\u4e09\u65b9\u5c0f\u7a0b\u5e8f\u6388\u6743token\u4e3a\u8fd4\u56de\u7684\u7b2c\u4e09\u65b9APPID\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)wxOpenInfo.getComponentAccessToken(), (String)"\u8c03\u7528\u7b2c\u4e09\u65b9\u5c0f\u7a0b\u5e8f\u6388\u6743token\u4e3a\u8fd4\u56de\u7684\u7b2c\u4e09\u65b9AccessToken\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)wxOpenInfo.getAuthorizerAppid(), (String)"\u8c03\u7528\u7b2c\u4e09\u65b9\u5c0f\u7a0b\u5e8f\u6388\u6743token\u4e3a\u8fd4\u56de\u7684\u6388\u6743APPID\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)wxOpenInfo.getAuthorizerAccessToken(), (String)"\u8c03\u7528\u7b2c\u4e09\u65b9\u5c0f\u7a0b\u5e8f\u6388\u6743token\u4e3a\u8fd4\u56de\u7684\u6388\u6743AccessToken\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notNull((Object)wxOpenInfo.getEndTime(), (String)"\u8c03\u7528\u7b2c\u4e09\u65b9\u5c0f\u7a0b\u5e8f\u6388\u6743token\u4e3a\u8fd4\u56de\u7684AccessToken\u8fc7\u671f\u65f6\u95f4\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.isTrue((wxOpenInfo.getEndTime() > 0 ? 1 : 0) != 0, (String)"\u7b2c\u4e09\u65b9\u5c0f\u7a0b\u5e8f\u6388\u6743token\u4e3a\u8fd4\u56de\u7684AccessToken\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u8bd5\uff01\uff01\uff01", (Object[])new Object[0]);
                this.redisMutexService.setMCode(WX_OPEN_INFO_CACHE, mapKey, JSONObject.toJSONString((Object)wxOpenInfo), (long)(wxOpenInfo.getEndTime() * 1000));
                WxOpenInfo wxOpenInfo2 = wxOpenInfo;
                return wxOpenInfo2;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new UncheckedExecutionException((Throwable)e);
        }
        finally {
            if (this.redisMutexService.islock(lockKey)) {
                this.redisMutexService.unlock(lockKey);
            }
        }
        return null;
    }

    public WxOpenInfo getWxOpenParams(InternalWxOpenInfoProcessor.InternalWxOpenInfoParam param) {
        WxOpenInfo wxOpenInfo = this.wxOpenHttpExecutor.doExecute(() -> new HttpGet(String.format(param.getUrl(), param.getTenantCode(), param.getAppletType())), httpResponse -> {
            String response;
            try {
                response = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new UncheckedIOException(e);
            }
            JSONObject parseObject = JSONObject.parseObject((String)response);
            Validate.isTrue((boolean)((Boolean)parseObject.get((Object)"success")), (String)"\u8c03\u7528\u5185\u90e8\u7b2c\u4e09\u65b9\u5c0f\u7a0b\u5e8f\u5931\u8d25\u6e90\u4fe1\u606f\uff1a%s", (Object[])new Object[]{response});
            Validate.notNull((Object)parseObject.get((Object)"data"), (String)"\u8c03\u7528\u5185\u90e8\u7b2c\u4e09\u65b9\u5c0f\u7a0b\u5e8f\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
            return (WxOpenInfo)((JSONObject)parseObject.get((Object)"data")).toJavaObject(WxOpenInfo.class);
        });
        return wxOpenInfo;
    }

    @Override
    public InternalWxOpenInfoProcessor getWxOpenInitializationProcessor() {
        return this.internalWxOpenInfoProcessor;
    }

    @Override
    public WxOpenUserProcessor getWxOpenUserProcessor() {
        return this.wxOpenUserProcessor;
    }

    @Override
    public WxOpenQrcodeProcessor getWxOpenQrcodeProcessor() {
        return this.wxOpenQrcodeProcessor;
    }
}

