/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.sdk.utils.wx.open;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.utils.wx.open.WxOpenHttpExecute;
import com.biz.crm.business.common.sdk.utils.wx.open.WxOpenInfo;
import com.biz.crm.business.common.sdk.utils.wx.open.WxOpenJscode2SessionResult;
import com.biz.crm.business.common.sdk.utils.wx.open.WxOpenServiceProvision;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.Validate;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxOpenUserProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(WxOpenUserProcessor.class);
    private final WxOpenHttpExecute wxOpenHttpExecutor;
    private final WxOpenServiceProvision wxOpenServiceProvision;

    WxOpenUserProcessor(WxOpenServiceProvision wxOpenServiceProvision, WxOpenHttpExecute wxOpenHttpExecutor) {
        this.wxOpenServiceProvision = wxOpenServiceProvision;
        this.wxOpenHttpExecutor = wxOpenHttpExecutor;
    }

    public WxOpenJscode2SessionResult getSessionInfo(String code) {
        Validate.notBlank((CharSequence)code, (String)"\u901a\u8fc7JsCode\u83b7\u53d6\u5fae\u4fe1\u7b2c\u4e09\u65b9\u5c0f\u7a0b\u5e8f\u7528\u6237\u4fe1\u606f\u65f6\uff0cJsCode\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01\uff01", (Object[])new Object[0]);
        Supplier<HttpRequestBase> request = () -> {
            WxOpenInfo wxOpenInfo = this.wxOpenServiceProvision.getWxOpenInfo();
            Validate.notNull((Object)wxOpenInfo, (String)"\u672a\u627e\u5230\u7b2c\u4e09\u65b9\u5c0f\u7a0b\u5e8f\u914d\u7f6e\u4fe1\u606f\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)wxOpenInfo.getAuthorizerAppid(), (String)"\u7b2c\u4e09\u65b9\u5c0f\u7a0b\u5e8f\u7684APPID\u4fe1\u606f\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)wxOpenInfo.getComponentAppid(), (String)"\u7b2c\u4e09\u65b9\u5c0f\u7a0b\u5e8f\u7684\u7b2c\u4e09\u65b9APPID\u4fe1\u606f\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)wxOpenInfo.getComponentAccessToken(), (String)"\u7b2c\u4e09\u65b9\u5c0f\u7a0b\u5e8f\u7684\u7b2c\u4e09\u65b9AccessToken\u4fe1\u606f\u7a7a", (Object[])new Object[0]);
            String url = String.format("https://api.weixin.qq.com/sns/component/jscode2session?appid=%s&js_code=%s&grant_type=%s&component_appid=%s&component_access_token=%s", wxOpenInfo.getAuthorizerAppid(), code, "authorization_code", wxOpenInfo.getComponentAppid(), wxOpenInfo.getComponentAccessToken());
            return new HttpGet(url);
        };
        Function<CloseableHttpResponse, WxOpenJscode2SessionResult> response = httpResponse -> {
            String responseStr;
            try {
                responseStr = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                Validate.notBlank((CharSequence)responseStr, (String)"\u5fae\u4fe1\u7b2c\u4e09\u65b9\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a!!!", (Object[])new Object[0]);
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new UncheckedIOException(e);
            }
            Validate.isTrue((!responseStr.contains("errcode") ? 1 : 0) != 0, (String)"\u5fae\u4fe1\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a\u3010%s\u3011", (Object[])new Object[]{responseStr});
            return (WxOpenJscode2SessionResult)JSONObject.parseObject((String)responseStr, WxOpenJscode2SessionResult.class);
        };
        return this.wxOpenHttpExecutor.doExecute(request, response);
    }
}

