package com.biz.crm.business.common.local.deprecated.service;

import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.business.common.sdk.deprecated.vo.CrmBaseVo;
import com.bizunited.nebula.common.service.CopyObjectCallback;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 新版本Entity属性赋值到老版本VO
 *
 * @author ning.zhang
 * @date 2021/10/11
 */
@Component
@Deprecated
public class CrmCopyNewEntityToOldVoCallbackImpl implements CopyObjectCallback<UuidOpEntity, CrmBaseVo> {

  @Override
  public boolean validate(Class<?> sourceClass, Class<?> targetClass) {
    return UuidOpEntity.class.isAssignableFrom(sourceClass) && CrmBaseVo.class.isAssignableFrom(targetClass);
  }

  @Override
  public void callback(Class<UuidOpEntity> sourceClass, List<UuidOpEntity> sourceObjects,
      Class<CrmBaseVo> targetClass, List<CrmBaseVo> targetObjects) {
    for (int i = 0; i < sourceObjects.size(); i++) {
      UuidOpEntity sourceObject = sourceObjects.get(i);
      CrmBaseVo targetObject = targetObjects.get(i);
      // 只要存在UuidOpEntity -> CrmBaseVo的转换，以下属性都要进行这样的赋值
      if (UuidFlagOpEntity.class.isAssignableFrom(sourceClass)) {
        UuidFlagOpEntity flagOpEntity = (UuidFlagOpEntity) sourceObject;
        targetObject.setRemarks(flagOpEntity.getRemark());
      }
      targetObject.setCreateCode(sourceObject.getCreateAccount());
      targetObject.setUpdateCode(sourceObject.getModifyAccount());
      if (sourceObject.getCreateTime() != null) {
        targetObject.setCreateDate(DateFormatUtils.format(sourceObject.getCreateTime(), "yyyy-MM-dd"));
        targetObject.setCreateDateSecond(DateFormatUtils.format(sourceObject.getCreateTime(), "HH:mm:ss"));
        targetObject.setCreateDateAll(DateFormatUtils.format(sourceObject.getCreateTime(), "yyyy-MM-dd HH:mm:ss"));
      }
      if (sourceObject.getModifyTime() != null) {
        targetObject.setUpdateDate(DateFormatUtils.format(sourceObject.getModifyTime(), "yyyy-MM-dd"));
        targetObject.setUpdateDateSecond(DateFormatUtils.format(sourceObject.getModifyTime(), "HH:mm:ss"));
        targetObject.setUpdateDateAll(DateFormatUtils.format(sourceObject.getModifyTime(), "yyyy-MM-dd HH:mm:ss"));
      }
    }

  }
}
