package com.biz.crm.business.common.local.deprecated.service;

import com.biz.crm.business.common.sdk.deprecated.vo.CrmBaseVo;
import com.biz.crm.business.common.sdk.vo.UuidFlagOpVo;
import com.biz.crm.business.common.sdk.vo.UuidOpVo;
import com.bizunited.nebula.common.service.CopyObjectCallback;

import java.util.List;

import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.stereotype.Component;

/**
 * 新版本VO属性赋值到老版本VO
 *
 * @author ning.zhang
 * @date 2021/10/11
 */
@Component
@Deprecated
public class CrmCopyNewVoToOldVoCallbackImpl implements CopyObjectCallback<UuidOpVo, CrmBaseVo> {

  @Override
  public boolean validate(Class<?> sourceClass, Class<?> targetClass) {
    return UuidOpVo.class.isAssignableFrom(sourceClass) && CrmBaseVo.class.isAssignableFrom(targetClass);
  }
  
  @Override
  public void callback(Class<UuidOpVo> sourceClass, List<UuidOpVo> sourceObjects,
      Class<CrmBaseVo> targetClass, List<CrmBaseVo> targetObjects) {
    for (int i = 0; i < sourceObjects.size(); i++) {
      UuidOpVo sourceObject = sourceObjects.get(i);
      CrmBaseVo targetObject = targetObjects.get(i);

      if (UuidFlagOpVo.class.isAssignableFrom(sourceClass)) {
        UuidFlagOpVo flagOpVo = (UuidFlagOpVo) sourceObject;
        targetObject.setRemarks(flagOpVo.getRemark());
      }

      targetObject.setCreateCode(sourceObject.getCreateAccount());
      targetObject.setUpdateCode(sourceObject.getModifyAccount());
      if (sourceObject.getCreateTime() != null) {
        targetObject.setCreateDate(DateFormatUtils.format(sourceObject.getCreateTime(), "yyyy-MM-dd"));
        targetObject.setCreateDateSecond(DateFormatUtils.format(sourceObject.getCreateTime(), "HH:mm:ss"));
        targetObject.setCreateDateAll(DateFormatUtils.format(sourceObject.getCreateTime(), "yyyy-MM-dd HH:mm:ss"));
      }
      if (sourceObject.getModifyTime() != null) {
        targetObject.setUpdateDate(DateFormatUtils.format(sourceObject.getModifyTime(), "yyyy-MM-dd"));
        targetObject.setUpdateDateSecond(DateFormatUtils.format(sourceObject.getModifyTime(), "HH:mm:ss"));
        targetObject.setUpdateDateAll(DateFormatUtils.format(sourceObject.getModifyTime(), "yyyy-MM-dd HH:mm:ss"));
      }
    }
  }
}
