package com.biz.crm.business.common.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.bizunited.nebula.common.util.JsonUtils;

import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.bizunited.nebula.security.sdk.refresh.AuthenticationRefreshStrategy;
import com.google.common.collect.Lists;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;

import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * 从SecurityContextHolder上下文中获取当前登录用户信息
 *
 * @author pengxi yinwenjie
 * @date 2021-07-27
 */
@Service
public class DefaultLoginUserServiceImpl implements LoginUserService {
  @Autowired(required = false)
  private List<AuthenticationRefreshStrategy> authenticationRefreshStrategies;

  @Override
  public Authentication getAuthentication(){
    if (SecurityContextHolder.getContext() != null &&
        SecurityContextHolder.getContext().getAuthentication() != null) {
      return SecurityContextHolder.getContext().getAuthentication();
    }
    return null;
  }

  @Override
  public String getLoginAccountName() {
    if (this.getAuthentication() == null) {
      return null;
    }
    return this.getAuthentication().getName();
  }

  @Override
  public UserIdentity getLoginUser() {
    if (this.getAuthentication() == null) {
      return null;
    }
    Object details = this.getAuthentication().getDetails();
    if(details == null) {
      return null;
    }
    if (details instanceof UserIdentity) {
      return (UserIdentity) details;
    }
    return null;
  }

  @Override
  public AbstractCrmUserIdentity getAbstractLoginUser() {
    UserIdentity loginUser = this.getLoginUser();
    if (loginUser instanceof AbstractCrmUserIdentity) {
      return (AbstractCrmUserIdentity) loginUser;
    }
    return null;
  }

  @Override
  public JSONObject getLoginUserJson() {
    UserIdentity loginUser = this.getLoginUser();
    return JsonUtils.toJSONObject(loginUser);
  }

  @SuppressWarnings("unchecked")
  @Override
  public <T extends UserIdentity> T getLoginDetails(Class<T> targetClass) {
    if (this.getAuthentication() == null) {
      return null;
    }
    Object details = this.getAuthentication().getDetails();
    T targetObject = null;
    if (details instanceof UserIdentity) {
      targetObject = (T) details;
    }
    return targetObject;
  }

  @Override
  public String findCurrentAccount() {
    SecurityContext securityContext = SecurityContextHolder.getContext();
    if(securityContext == null) {
      return "admin";
    }
    Authentication authentication = securityContext.getAuthentication();
    if(authentication == null) {
      return "admin";
    }
    return authentication.getName();
  }

  @Override
  public Authentication refreshAuthentication(Object userInfo) {
    if(CollectionUtils.isEmpty(authenticationRefreshStrategies)) {
      return null;
    }
    
    for (AuthenticationRefreshStrategy authenticationRefreshStrategy : authenticationRefreshStrategies) {
      if(authenticationRefreshStrategy.matched(userInfo)) {
        UserIdentity userIdentity = authenticationRefreshStrategy.refresh(userInfo);
        // 如果条件成立，说明刷新过程没有成功
        if(userIdentity == null) {
          return null;
        }
        // 生成用户身份并进行返回，注意，角色信息非常重要
        List<SimpleGrantedAuthority> grantedAuthorities = Lists.newArrayList();
        String[] roleCodes = userIdentity.getRoleCodes();
        if(roleCodes != null && roleCodes.length > 0) {
          for (String roleCode : roleCodes) {
            grantedAuthorities.add(new SimpleGrantedAuthority(roleCode));
          }
        }
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken(userIdentity.getAccount(), "123456", grantedAuthorities);
        authentication.setDetails(userIdentity);
        SecurityContextHolder.getContext().setAuthentication(authentication);
        return authentication;
      }
    }
    // 如果执行到这里，就说明没有任何的用户身份刷新策略匹配成功
    return null;
  }
}