package com.biz.crm.business.common.sdk.model;

import com.bizunited.nebula.common.util.tenant.TenantContextHolder;
import com.bizunited.nebula.common.vo.SimpleTenantInfo;
import com.bizunited.nebula.security.sdk.loginform.LoginDetails;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.regex.Pattern;

/**
 * 抽象登录用户
 *
 * @author hefan
 * @date 2022/04/21
 */
@Getter
@Setter
public abstract class AbstractLoginUser implements LoginDetails,Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = -4201160752652020572L;
  /**
   * 登录方式类型：1、典型的用户名+密码方式；2、典型的用户名 + 密码 + 校验码方式；3、用户名 + 短信验证码 + 校验码方式；
   * 4、手机号 + 密码方式；5、手机号 + 短信验证码；6、手机号 + 短信验证码 + 校验码方式</br>
   * 当然，这里type也可以为null或者小于等于0的一个数，这种情况下，登录逻辑将采用第1中鉴权方式
   */
  private Integer type = null;
  /**
   * 经销商编码
   */
  private String tenantCode;
  /**
   * 输入的用户名
   */
  private String username;
  /**
   * 输入的账户信息
   */
  private String account;
  /**
   * 输入的明文密码
   */
  private String password;
  /**
   * 输入的校验码（一般用于放置机器人操作）
   */
  private String checkCode;
  /**
   * 输入的短信验证码
   */
  private String smsVerificationCode;
  /**
   * 输入的手机号
   */
  private String phone;
  /**
   * 用户在上下文会话中的唯一标识。该信息不需要调用者传递，而LoginDetails内部将进行记录
   */
  private String sessionId;
  
  /**
   * 这是带有request请求的用户初始化
   * @param request
   */
  public AbstractLoginUser(HttpServletRequest request) { 
    // 确认典型鉴权方式的类型
    String typeValue =  request.getParameter("type");
    // 注意，可能前端并没有传递type信息
    if(!StringUtils.isBlank(typeValue) && isNumeric(typeValue)) { 
      this.type = Integer.parseInt(typeValue);
    }
    // 经销商编码
    this.tenantCode = request.getParameter("tenantCode");
    if(StringUtils.isNotBlank(this.tenantCode)) {
      SimpleTenantInfo simpleTenantInfo = new SimpleTenantInfo(this.tenantCode);
      TenantContextHolder.setTenantInfo(simpleTenantInfo);
    }
    this.sessionId = request.getSession().getId();
    // 可能输入的手机号(用户名)
    this.username = request.getParameter("username");
    // 可能的账户信息
    this.account = request.getParameter("account");
    // 可能输入的明文密码
    this.password = request.getParameter("password");
    // 可能输入的校验码
    this.checkCode = request.getParameter("checkCode");
    // 可能输入的短信验证码
    this.smsVerificationCode = request.getParameter("smsVerificationCode");
    // 可能输入的手机号
    this.phone = request.getParameter("phone");
    // CRM系统扩展字段
    // 可能输入的用户类型
    this.usertype = request.getParameter("usertype");
    // 业务系统类型
    String appType = request.getParameter("appType");
    if (appType != null) {
      this.appType = Integer.valueOf(appType);
    }
  }
  
  /**
   * 用于不是那些基于http request进行用户创建的场景
   * @param account
   * @param username
   * @param tenantCode
   */
  public AbstractLoginUser(String account , String username , String tenantCode) {
    this.account = account;
    this.username = username;
    this.tenantCode = tenantCode;
  }
  
  /**
   * .该正则表达式可以匹配所有的数字 包括负数
   * @param str
   * @return
   */
  private boolean isNumeric(String str) {
    Pattern pattern = Pattern.compile("^[0-9]+$");
    return pattern.matcher(str).find();
  }
  
  /**
   * 业务系统类型
   */
  private Integer appType;

  /**
   * 真实姓名
   */
  private String realName;

  /**
   * 用户类别(u-企业用户，c-客户用户，terminal-终端用户，customer_employee - 经销商员工用户)
   */
  private String usertype;
  /**
   * 得到岗位编码
   *
   * @return {@link String}
   */
  public abstract String getPostCode();

  /**
   * 岗位名称
   *
   * @return {@link String}
   */
  public abstract String getPostName();

}
