package com.biz.crm.business.common.sdk.utils;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/**
 * Spring上下文获取Request的工具类
 * 
 * @author Ken
 * @version 1.0 Copyright 2022年11月16日 上午11:47:58
 */
public class RequestUtils {
  /**
   * 获取request对象
   * 
   * @return
   */
  public static HttpServletRequest getRequest() {
    HttpServletRequest request =
        ((ServletRequestAttributes) (RequestContextHolder.currentRequestAttributes())).getRequest();
    return request;
  }

  /**
   * 测试模块，用于探针
   * 
   * @param request
   * @return 探针返回的数据List<String>
   * @deprecated 该方法仅限用于定位请求跟踪数据使用，请勿使用到正式环境中！！！
   */
  public static List<String> tanzhen(HttpServletRequest request) {
    List<String> list = new ArrayList<>();
    list.add(String.format("服务器名称:%s", request.getServerName()));
    list.add(String.format("系统:%s", System.getProperty("os.name")));
    list.add(String.format("request ip is : %s", request.getRemoteHost()));
    Enumeration<String> headerNames = request.getHeaderNames();
    while (headerNames.hasMoreElements()) {
      String headerName = (String) headerNames.nextElement();
      list.add(String.format(" %s=%s ", headerName, request.getHeader(headerName)));
    }
    return list;
  }
}
