/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.sdk.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class HttpServletRequestUtil {
    public static HttpServletRequest getRequest() {
        HttpServletRequest request = null;
        ServletRequestAttributes servletRequestAttributes = null;
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            servletRequestAttributes = (ServletRequestAttributes)requestAttributes;
            request = servletRequestAttributes.getRequest();
        }
        return request;
    }

    public static HttpServletResponse getResponse() {
        HttpServletResponse response = null;
        ServletRequestAttributes servletRequestAttributes = null;
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            servletRequestAttributes = (ServletRequestAttributes)requestAttributes;
            response = servletRequestAttributes.getResponse();
        }
        return response;
    }

    public static void writeResponseFile(byte[] result, String fileName) {
        HttpServletRequestUtil.writeResponseFile(HttpServletRequestUtil.getRequest(), HttpServletRequestUtil.getResponse(), result, fileName);
    }

    public static void writeResponseFile(HttpServletRequest request, HttpServletResponse response, byte[] result, String fileName) {
        String currentFileName;
        try {
            currentFileName = StringUtils.isBlank((CharSequence)fileName) ? "temp" : URLEncoder.encode(fileName, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException var9) {
            currentFileName = "temp";
        }
        response.setContentType("application/octet-stream;charset=utf-8");
        response.addHeader("Content-Disposition", "attachment;fileName=" + HttpServletRequestUtil.encodeFileName(request, currentFileName));
        try (ServletOutputStream out = response.getOutputStream();){
            out.write(result);
        }
        catch (IOException var8) {
            throw new IllegalArgumentException(var8.getMessage(), var8);
        }
        finally {
            response.reset();
        }
    }

    private static String encodeFileName(HttpServletRequest request, String fileName) {
        String agent = request.getHeader("User-Agent");
        if (StringUtils.isBlank((CharSequence)agent)) {
            try {
                return URLEncoder.encode(fileName, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (!agent.contains("Firefox") && !agent.contains("Safari")) {
            if (agent.contains("Chrome")) {
                try {
                    fileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8.name());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
        } else {
            fileName = new String(fileName.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
        }
        return fileName;
    }
}

