package com.biz.crm.business.common.sdk.enums;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

/**
 * @Description:crm数据业务状态
 * @Author: hefan
 * @Date: 2020/8/20 18:25
 **/
public enum LockStateEnum {
  /**
   * 编码与描述
   */
  LOCK("003","禁用"),
  UNLOCK("009","启用");

  private String code;
  private String des;

  LockStateEnum(String code, String des) {
    this.code = code;
    this.des = des;
  }

  public String getCode() {
    return code;
  }

  public String getDes() {
    return des;
  }

  /**
   * code转数组
   * @return
   */
  public static Set<String> codeToSet(){
    Set<String> codes = new HashSet<>();
    for (LockStateEnum enableStatusEnum : LockStateEnum.values()) {
      codes.add(enableStatusEnum.getCode());
    }
    return codes;
  }

  /**
   * 根据code获取文字描述
   * @param code
   * @return
   */
  public static String getDesc(String code) {
    if (!StringUtils.isEmpty(code)) {
      LockStateEnum[] values = LockStateEnum.values();
      for (LockStateEnum value : values) {
        if (value.code.equals(code)) {
          return value.des;
        }
      }
    }
    return null;
  }



  /**
   * 判断枚举中是否包含该code
   * @param code
   * @return
   */
  public static boolean contains(String code) {
    if (StringUtils.isEmpty(code)) {
      return false;
    }
    LockStateEnum[] values = LockStateEnum.values();
    for (LockStateEnum value : values) {
      if (value.getCode().equals(code)) {
        return true;
      }
    }
    return false;
  }

}

