package com.biz.crm.business.common.sdk.model;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author jerry7 yinwenjie
 * @date 2021/8/4 11:11
 * 用户登录信息实体类，继承common-sdk的UserRedisInfo，实现springframework.security的UserDetails接口，用于获取数据用户登录信息</br>
 * 并由yinwenjie，在2021年-08-15做出设计变化
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
public class LoginUserDetails extends AbstractLoginUser {
  private static final long serialVersionUID = -2989751616033874651L;

  /**
   * 岗位编码
   */
  private String postCode;
  /**
   * 岗位名称
   */
  private String postName;
  /**
   * 组织编码
   */
  private String orgCode;
  /**
   * 组织名称
   */
  private String orgName;
  /**
   * 语言
   */
  private String language;

  /**
   * 来源类型
   */
  private String fromType;

  /**
   * openid 微信openid 或者支付宝 用户id
   */
  private String openId;

  /**
   * 当前用户的角色信息
   */
  private List<String> roles;

  public LoginUserDetails(HttpServletRequest request) {
    super(request);
  }

  public LoginUserDetails(String account, String username, String tenantCode) {
    super(account, username, tenantCode);
  }  
}
