package com.biz.crm.business.common.sdk.service;

import com.biz.crm.business.common.sdk.dto.TreeDto;
import java.util.List;
import java.util.Set;

/**
 * 树 ruleCode 生成策略
 *
 * @author hecheng
 * @date 2021-09-30
 */
public interface TreeRuleCodeStrategy {

  /**
   * 策略标识
   *
   * @return
   */
  String getKey();

  /**
   * 根据父级ruleCode编码规则生成本层指定的ruleCode编码
   *
   * @param ruleCodeSplitLength 每一级编码的长度
   * @param parentRuleCode      父节点ruleCode编码
   * @param children            父节点下的所有子节点 如果不存在父级节点，那么为所有没有父节点的分支中
   * @return 生成的编码
   */
  String generate(int ruleCodeSplitLength, String parentRuleCode, List<TreeDto> children);

  /**
   * 数字转换成一层指定长度的降维编码
   * <pre>
   *
   *   例如：当ruleCodeSplitLength=3,num=1
   *   输出=》001
   * </pre>
   *
   * @param num
   * @return
   */
  String generateByNum(int ruleCodeSplitLength, int num);

  /**
   * 根据降维编码分离出上级降维编码集合(返回值不包含任何一个参数里的编码)
   * <pre>
   *
   *   例如：当ruleCodeSplitLength=3,ruleCodes={003001001,003001}
   *   原本parentRuleCode={003、003001}排除入参后
   *   输出=》003
   * </pre>
   *
   * @param ruleCodeSplitLength
   * @param ruleCodes
   * @return
   */
  Set<String> findParentRuleCodeByRuleCodesExcludeAnySelf(int ruleCodeSplitLength, List<String> ruleCodes);

  /**
   * 根据降维编码分离出上级降维编码集合(不包含自己，如果本身编码集合已经有包含关系也会返回)
   * <pre>
   *
   *   例如：当ruleCodeSplitLength=3,ruleCodes=003001001
   *   原本parentRuleCode={003、003001}排除入参后
   *   输出=》003、003001
   * </pre>
   *
   * @param ruleCodeSplitLength
   * @param ruleCode
   * @return
   */
  Set<String> findParentRuleCodesByRuleCodeExcludeSelf(int ruleCodeSplitLength, String ruleCode);

  /**
   * 根据降维编码分离出上级降维编码集合(不包含自己，如果本身编码集合已经有包含关系也会返回)
   * <pre>
   *
   *   例如：当ruleCodeSplitLength=3,ruleCodes={003001001,003001}
   *   原本parentRuleCode={003、003001}排除入参后
   *   输出=》003,003001
   * </pre>
   *
   * @param ruleCodeSplitLength
   * @param ruleCodes
   * @return
   */
  Set<String> findParentRuleCodesByRuleCodesExcludeSelf(int ruleCodeSplitLength, List<String> ruleCodes);

  /**
   * 根据降维编码分离出上级降维编码集合
   * <pre>
   *
   *   例如：当ruleCodeSplitLength=3,ruleCodes=003001001
   *   原本parentRuleCode={003、003001、003001001}
   *   输出=》{003、003001、003001001}
   *  </pre>
   *
   * @return
   */
  Set<String> findParentRuleCodeByRuleCode(int ruleCodeSplitLength, String ruleCode);

  /**
   * 根据降维编码集合分离出上级降维编码集合
   * <pre>
   *
   *   例如：当ruleCodeSplitLength=3,ruleCodes={003001001}
   *   原本parentRuleCode={003、003001、003001001}
   *   输出=》{003、003001、003001001}
   *  </pre>
   *
   * @return
   */
  Set<String> findParentRuleCodeByRuleCodes(int ruleCodeSplitLength, List<String> ruleCodes);
}
