package com.biz.crm.business.common.sdk.strategy;

import feign.RequestTemplate;
import org.apache.commons.collections.CollectionUtils;

import java.util.Collection;
import java.util.Map;

/**
 * 当应用程序中的fegin在进行调用时，需要尽可能保证当前请求者的身份会话信息向服务端传递。</br>
 * 而请求者的身份信息可能来源于多种渠道，例如如果当前线程存在http请求上下文，那么身份信息往往携带于http请求的head信息中；</p>
 * 
 * 所以技术人员可以实现该接口，设定当前的fegin信息从哪里来。默认common包提供了两种fegin信息的来源：
 * RequestContextTransmitStrategyImpl和SecurityContextTransmitStrategyImpl（详情请参见）
 * 
 * @author pengxi yinwenjie
 * @deprecated 请直接使用nebula提供的NebulaFeignRequestInterceptor
 * @date 2021-07-27
 */
@Deprecated
public interface ContextTransmitStrategy {

  /**
   * 需要检查的头信息cookie
   */
  String COOKIE = "cookie";

  /**
   * 检查是否已经存在上下文
   *
   * @param requestTemplate 请求模板
   * @return boolean
   */
  default boolean existed(RequestTemplate requestTemplate){
    Map<String, Collection<String>> headers = requestTemplate.headers();
    if (headers.isEmpty()) {
      return Boolean.FALSE;
    }
    if (headers.containsKey(COOKIE) && CollectionUtils.isNotEmpty(headers.get(COOKIE))) {
      return Boolean.TRUE;
    }
    return Boolean.FALSE;
  }

  /**
   * 传递上下文
   *
   * @param requestTemplate 请求模板
   */
  void transmit(RequestTemplate requestTemplate);

  /**
   * 执行优先级（值越小优先级越高）
   *
   * @return int
   */
  int order();
}
