package com.biz.crm.business.common.local.deprecated.service;

import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.business.common.sdk.deprecated.vo.CrmBaseVo;

import com.bizunited.nebula.common.service.CopyObjectCallback;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.util.List;

/**
 * 老版本VO属性赋值到新版本Entity
 *
 * @author ning.zhang
 * @date 2021/10/11
 */
@Component
@Deprecated
public class CrmCopyOldVoToNewEntityCallbackImpl implements CopyObjectCallback<CrmBaseVo, UuidOpEntity> {

  @Override
  public boolean validate(Class<?> sourceClass, Class<?> targetClass) {
    return CrmBaseVo.class.isAssignableFrom(sourceClass) && UuidOpEntity.class.isAssignableFrom(targetClass);
  }

  @Override
  public void callback(Class<CrmBaseVo> sourceClass, List<CrmBaseVo> sourceObjects,
      Class<UuidOpEntity> targetClass, List<UuidOpEntity> targetObjects) {
    for (int i = 0; i < sourceObjects.size(); i++) {
      CrmBaseVo sourceObject = sourceObjects.get(i);
      UuidOpEntity targetObject = targetObjects.get(i);

      if (UuidFlagOpEntity.class.isAssignableFrom(targetClass)) {
        UuidFlagOpEntity flagOpEntity = (UuidFlagOpEntity) targetObject;
        flagOpEntity.setRemark(sourceObject.getRemarks());
      }
      targetObject.setCreateAccount(sourceObject.getCreateCode());
      targetObject.setModifyAccount(sourceObject.getUpdateCode());
      try {
        if (StringUtils.isNotBlank(sourceObject.getUpdateDateAll())) {
          targetObject.setModifyTime(DateUtils.parseDate(sourceObject.getUpdateDateAll(), "yyyy-MM-dd HH:mm:ss"));
        }
        if (StringUtils.isNotBlank(sourceObject.getCreateDateAll())) {
          targetObject.setCreateTime(DateUtils.parseDate(sourceObject.getCreateDateAll(), "yyyy-MM-dd HH:mm:ss"));
        }
      } catch (ParseException e) {
        throw new IllegalArgumentException(e);
      }
    }
  }
}
